package generators;

/** Regular expressions over N, used by the implementation of ET0L tree grammars.
  */
public class rexp {

  public static final int STAR = -1;
  public static final int PLUS = -2;
  public static final int UNION = -3;
  public static final int CONC = -4;
  public static final int OPT = -5;
  
  public int type;
  public rexp[] subexp = null;
  
  private boolean containsLoop = false;
  
  public static rexp num(int c) {
    rexp result = new rexp();
    result.type = c;
    return result;
  }
    
  public static rexp star(rexp e) {
    rexp result = new rexp();
    result.type = STAR;
    result.subexp = new rexp[1];
    result.subexp[0] = e;
    result.containsLoop = true;
    return result;
  }
    
  public static rexp plus(rexp e) {
    rexp result = new rexp();
    result.type = PLUS;
    result.subexp = new rexp[1];
    result.subexp[0] = e;
    result.containsLoop = true;
    return result;
  }
    
  public static rexp union(rexp e, rexp f) {
    rexp result = new rexp();
    result.type = UNION;
    result.subexp = new rexp[2];
    result.subexp[0] = e;
    result.subexp[1] = f;
    result.containsLoop = e.containsLoop || f.containsLoop;
    return result;
  }
    
  public static rexp conc(rexp e, rexp f) {
    rexp result = new rexp();
    result.type = CONC;
    result.subexp = new rexp[2];
    result.subexp[0] = e;
    result.subexp[1] = f;
    result.containsLoop = e.containsLoop || f.containsLoop;
    return result;
  }
    
  public static rexp opt(rexp e) {
    rexp result = new rexp();
    result.type = OPT;
    result.subexp = new rexp[1];
    result.subexp[0] = e;
    result.containsLoop = e.containsLoop;
    return result;
  }
  
  public boolean containsLoop() {
    return containsLoop;
  }
  
  public String toString() {
    switch (type) {
      case STAR:
        return "(" + subexp[0].toString() + ")*";
      case PLUS:
        return "(" + subexp[0].toString() + ")+";
      case UNION:
        return "(" + subexp[0].toString() + ", "
                   + subexp[1].toString() + ")";
      case CONC:
        return subexp[0].toString() + subexp[1].toString();
      case OPT:
        return "[" + subexp[0].toString() + "]";
      default: return Integer.toString(type);
    }
  }
}

