package gui.nodeTypes;

import java.awt.*;
import javax.swing.*;
import displays.*;
import algebras.*;
import gui.*;
import parsers.*;

public class displayNode extends worksheetNode {

  /**
	 * 
	 */
  private static final long serialVersionUID = 4008427967317872359L;
  private JFrame window = null;
  private static int xDist = 4*radius/7;
  private static int delta = radius/7;
  private static int yDist = 4*radius/9;
  private static int [] iconX = { -xDist, -xDist+delta, xDist-delta, xDist,
                                  xDist, xDist-delta, -xDist+delta, -xDist};
  private static int [] iconY = { yDist-delta, yDist, yDist, yDist-delta,
                                  -yDist+delta, -yDist, -yDist, -yDist+delta };

  public displayNode(display disp, String fileName) {
    super(disp, fileName);
    figureX = iconX;
    figureY = iconY;
  }
  
  public int openWindows() {
    return super.openWindows() + (window != null && window.isShowing() ? 1 : 0);
  }
  
  private synchronized boolean initWindow() {
    Component c = ((display)contents).visualizer();
    if (c != null) {
      window = new JFrame();
      windowTitle();
      Container cp = window.getContentPane();
      cp.setBackground(Color.white);
      cp.add(c);
      if (c instanceof scrollCanvas) {
        cp.add(((scrollCanvas)c).getVScrollBar(),BorderLayout.EAST);
        cp.add(((scrollCanvas)c).getHScrollBar(),BorderLayout.SOUTH);
      }
      window.pack();
      Point p = parent().getLocationOnScreen();
      window.setLocation(new Point(p.x + position.x + radius, p.y + position.y + radius));
      return true;
    }
    else return false;
  }
  
  private void windowTitle() {
    if (window != null) {
      if (inputEdge != null) {
        worksheetNode source = (worksheetNode)inputEdge.source;
        String inputName = source.getName();
        window.setTitle(getName() + " (input: " + inputName + ")");
      }
      else window.setTitle(getName() + " <no input>");
    }
  }        
  
  public boolean acceptsSource(worksheetNode source) {
    if (!(source instanceof algebraNode)) return false;
    algebra alg = (algebra)((worksheetNode)source).contents;
    return ((display)contents).acceptable(alg);
  }
  
  public void inputEdgeEstablished(edge e) {
    super.inputEdgeEstablished(e);
    windowTitle();
    redisplay();
  }
  
  public void redisplay() {
    if (inputEdge != null) { 
      algebraNode source = (algebraNode)inputEdge.source;
      transferCommand(source.current(), VALUE);
    }
    else transferCommand(null, VALUE);
  }
  
  public void open() {
    if (window != null || initWindow()) {
      if (window.isShowing()) {
        window.setVisible(true);
        super.open();
      }
      else window.setVisible(true);
    }
    else super.open();
  }
  
  protected void reinit(parsable newContents) {
    super.reinit(newContents);
    Component c = ((display)contents).visualizer();
    if (window != null) {
      if (c != null) {
        Container cp = window.getContentPane();
        cp.removeAll();
        cp.add(c);
        if (c instanceof scrollCanvas) {
          cp.add(((scrollCanvas)c).getVScrollBar(),BorderLayout.EAST);
          cp.add(((scrollCanvas)c).getHScrollBar(),BorderLayout.SOUTH);
        }
        window.pack();
      }
      else {
        window.dispose();
        window = null;
      }
    }
  }
  
  public void runContents(Object command, int type) {
    if (type == VALUE) {
      display d = (display)contents;
      d.display(command);
    }
    else super.runContents(command, type);
  }
  
  public void inputEdgeDeleted(edge e) {
    super.inputEdgeDeleted(e);
    windowTitle();
    redisplay();
  }
  
  protected void dispose() {
    if (window != null) {
      window.getContentPane().removeAll();
      window.dispose();
    }
    window = null;
    super.dispose();
  }

}
