package gui.nodeTypes;

import terms.*;
import generators.*;
import gui.*;

public class treeTransducerNode extends treeGeneratorNode {

  /**
	 * 
	 */
  private static final long serialVersionUID = 8164629484694071076L;
  private static int l = radius/10;
  private static int a = radius/3;
  private static int [] iconX = { l, l, a, 0, -a, -l, -l };
  private static int [] iconY = { -radius+l, radius-2*a, radius-2*a,
                                  radius, radius-2*a, radius-2*a, -radius+l };

  public treeTransducerNode(treeTransducer mod, String fileName) {
    super(mod, fileName);
    figureX = iconX;
    figureY = iconY;
  }
  
  public void runContents(Object command, int type) {
    if (type == VALUE) {  // got a new input term
      term result;
      if (command == null) result = null;
      else result = ((treeTransducer)contents).apply((term)command);
      synchronized (this) { curr = result; }
      broadcastResult(result);
    }
    else super.runContents(command, type);
  }
  
  public boolean acceptsSource(worksheetNode source) {
    return source instanceof treeGeneratorNode && super.acceptsSource(source);
  }
  
  public void inputEdgeDeleted(edge e) {
    curr = null;
    super.inputEdgeDeleted(e);
  }
  
}
