package gui.nodeTypes;

import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import gui.*;
import parsers.*;
import util.*;

public class worksheetNode extends visibleNode implements Runnable, ActionListener {

  /**
	 * 
	 */
  private static final long serialVersionUID = -3135688418575383122L;
  public parsable contents;
  public String fileName = null;
  public static String edit = "edit";
  public static String reload = "reload";
  public static String delete = "delete";
  
  private static String[] commands = { edit, reload, delete };
  
  public static int USER_COMMAND = 0;
  public static int VALUE = 1;
  public static int STOP = 2;

  private commandPanel panel;
  private popupMenu menu;
  private exitableThread contentsThread;
  private list pendingCommands = new list();
  protected observable obs = new observable();
  protected edge inputEdge = null;
  private list editors = new list();
  
  public worksheetNode(parsable obj, String fileName) {
    super();
    this.fileName = fileName;
    contents = obj;
    addLabel(getName());
    addLabel("[" + obj.getClassName() + "]");
    panel = new commandPanel(this);
    menu = new popupMenu(this);
    add(menu);
  }

  public void inputEdgeEstablished(edge e) {
    if (inputEdge != null) parent().deleteEdge(inputEdge);
    inputEdge = e;
    worksheetNode source = (worksheetNode)e.source;
    transferCommand(source.current(), VALUE);
  }
  
  public void inputEdgeDeleted(edge e) {
    inputEdge = null;
    transferCommand(null, VALUE);
  }
  
  protected synchronized Object current() { return null; }
  
  public void start() {
    updateCommandList();
    contentsThread = new exitableThread(this);
    contentsThread.start();
  }

  public String getName() { return contents.getName(); }
  
  public void initialize() throws ParseException {
  }
  
  public int openWindows() {
    return worksheet.tabs.isShown(panel) ? 1 : 0;
  }
  
  public boolean acceptsSource(worksheetNode source) {
    return !parent().existsPath(this, source);
  }
  
  public void mousePressed(MouseEvent e) {
    if (e.isAltDown() || e.isMetaDown()) {
      menu.show(this, e.getPoint().x, e.getPoint().y);
    }
    else super.mousePressed(e);
  }
    
  public void actionPerformed(ActionEvent event) {
    componentGraph p = parent();
    p.addToActiveCount(1);
    String command = event.getActionCommand();
    if (edit.equals(command)) new editor(fileName, this);
    else if (reload.equals(command)) reload(fileName);
    else if (delete.equals(command)) delete(false);
    else transferCommand(command, USER_COMMAND);
    p.addToActiveCount(-1);
  }
  
  public boolean reload(String file) {
    exitableThread oldContentsThread = contentsThread;
    transferCommand(null, STOP);
    try { oldContentsThread.join(); } catch (InterruptedException e) {}
    boolean ok = false;
    parsable parsed = null;
    includer input = null;
    try {
      input = new includer(new File(file));
      objectParser parser = new objectParser(new ASCII_CharStream(input,1,1));
      parsed = parser.parse();
      fileName = file;
      ok = true;
    } catch (includer.IncludeFileNotFoundException e) {
      errorDisplay.show("Parsing of `" + fileName + "' failed: file not found");
    } catch (ParseException e) {
      errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
    } catch (TokenMgrError e) {
      errorDisplay.show("Parsing of `" + fileName + "' failed:\n" + e.getMessage());
    }
    finally { if (input != null) try { input.close(); } catch (IOException e) {}}
    if (ok) {
      if (parsed.getClass().equals(contents.getClass())) {
        if (parsed.getName() == null) {
          parsed.setName("file " + fileName.substring(fileName.lastIndexOf(File.separatorChar)+1));
        }
        reinit(parsed);
      }
      else errorDisplay.show("Reload failed! Unable to reload '" + fileName +
                                           "' because the class of the component has been changed");
    }
    updateCommandList();
    contentsThread = new exitableThread(this);
    contentsThread.start();
    if (inputEdge != null) {
      worksheetNode source = (worksheetNode)inputEdge.source;
      transferCommand(source.current(), VALUE);
    }
    else transferCommand(null, VALUE);
    return ok;
  }
  
  public void delete(boolean force) {
    if (force || confirm()) {
      while (!editors.isEmpty()) {
        ((editor)editors.head()).dispose();
        editors.removeFirst();
      }
      exitableThread oldContentsThread = contentsThread;
      transferCommand(null, STOP);
      try { oldContentsThread.join(); } catch (InterruptedException e) {}
      dispose();
      parent().deleteNode(this);
    }
  }
  
  public synchronized boolean isUnsaved() {
    list l = editors;
    while (!l.isEmpty()) {
      if (((editor)l.head()).isUnsaved()) return true;
      l = l.tail();
    }
    return false;
  }
  
  public synchronized void addEditor(editor ed) {
    editors.prepend(ed);
  }
  
  public synchronized void removeEditor(editor ed) {
    list l = editors;
    while (!l.isEmpty()) {
      if (l.head() == ed) {
        l.removeFirst();
        break;
      }
      else l = l.tail();
    }
  }
  
  public synchronized boolean confirm() {
    if (!isUnsaved()) return true;
    int choice = JOptionPane.showConfirmDialog(null,
      "Unsaved file(s). Delete node anyway?",
      "Unsaved file(s)!",
      JOptionPane.YES_NO_OPTION,
      JOptionPane.QUESTION_MESSAGE);
    return choice == 0;
  }
  
  public synchronized void transferCommand(Object com, int type) {
    if (type == STOP) {
      pendingCommands.removeAllElements();
      if (contentsThread != null) contentsThread.exitRequest(true);
    }
//    if (type == STOP ||
//        type == USER_COMMAND && (reload.equals(com) || delete.equals(com))) {
//      pendingCommands.removeAllElements();
//      if (contentsThread != null) contentsThread.exitRequest(true);
//    }
    else if (type == USER_COMMAND && edit.equals(com)) new editor(fileName, this);
    else if (type == VALUE || type == USER_COMMAND && contents instanceof reactive && ((reactive)contents).requestsExit((String)com)) {
      list l = pendingCommands;
      while (!l.isEmpty()) {
        if (((cmd)pendingCommands.head()).type == VALUE) l.removeFirst();
        else l = l.tail();
      }
      if (contentsThread != null) contentsThread.exitRequest(true);
    }
    pendingCommands.append(new cmd(com, type));
    notifyAll();
  }
  
  protected void broadcastResult(Object o) {
    obs.setChanged();
    obs.notifyObservers(o);
  }
  
  public void open() {
    if (!worksheet.tabs.isShown(panel)) worksheet.tabs.addTab(contents.getName(),panel);
  }
  
  private void updateCommandList() {
    list com = (contents instanceof reactive) ? ((reactive)contents).commands() : new list();
    com.append(commands);
    panel.setCommands(com);
    menu.setCommands(com);
  }
  
  public void run() {
    Object command;
    int type;
    while (true) {
      synchronized (this) {
        while (pendingCommands.isEmpty()) {
          try { wait(); } catch (InterruptedException e) {}
        }
        command = ((cmd)pendingCommands.head()).com;
        type = ((cmd)pendingCommands.head()).type;
        pendingCommands.removeFirst();
        contentsThread.exitRequest(false);
        notifyAll();
      }
      if (type == STOP) {
        contentsThread = null;
        synchronized (this) { notifyAll(); }
        break;
      }
      else {
        try {
          parent().addToActiveCount(1);
          runContents(command, type);
        }
        catch (ExitException e) {}
        finally { parent().addToActiveCount(-1); }
      }
      updateCommandList();
    }
  }
  
  public void runContents(Object command, int type) {
    if (type == USER_COMMAND && contents instanceof reactive) {
      ((reactive)contents).execute((String)command);
    }
  }
  
  protected synchronized void dispose() {
    panel.dispose();
    menu.removeActionListener(this);
    parent().removeComponentListener(this);
    contents.dispose();
    obs.deleteObservers();
  }
  
  public void addObservingEdge(edge e) {
    obs.addObserver(e);
  }
  
  public void deleteObservingEdge(edge e) {
    obs.deleteObserver(e);
  }
  
  protected void reinit(parsable newContents) {
    parsable oldContents = contents;
    contents = newContents;
    try { initialize(); }
    catch (ParseException e) {
      errorDisplay.show("Initialization failed:\n" + e.getMessage());
      contents = oldContents;
      return;
    }
    oldContents.dispose();
    contents.setName(contents.getBasename());
    removeLabels();
    addLabel(contents.getName());
    addLabel("[" + newContents.getClassName() + "]");
    invalidate();
    repaint();
  }
  
  private class cmd {
  
    public Object com;
    public int type;
  
    public cmd(Object c, int t) {
      com = c;
      type = t;
    }
  }
}
