package terms;

/** A ranked symbol.
  */
public class symbol {

  protected String name;
  protected int    rank;
  
/** A symbol whose name and rank are given as arguments.
  * @param n the name of the symbol
  * @param rk its rank
  */
  public symbol(String n, int rk) {
    name = n.intern();
    rank = rk;
  }
  
/** A symbol whose instance variables are not yet inititalised. */
  protected symbol() {} 
  
/** Returns the name of the symbol.
  * The names of symbols can be compared using the == operator because this method
  * returns the canonical representation of the string obtained by an application of the method
  * <code>intern()</code>.
  */
  public String toString() {
    return name;
  }

/** Returns the rank of the symbol.
  */
  public int rank() {
    return rank;
  }

/** Two symbols are equal iff their names and ranks coincide.
  */
  public boolean equals(Object other) {
    if (other instanceof symbol) {
      return name==((symbol)other).toString() && rank==((symbol)other).rank();
    }
    else return false;
  }

  public int hashCode() {
    return name.hashCode();
  }
  
}
