package util;

import java.util.*;

public class comp { 
  
/* Compares two objects recursively: If they are both arrays, both vectors,
 * or both lists the individual elements are compared, while all other objects
 * are compared using the <code>equals</code> method of the first object.
 */
  public static boolean compare(Object o1, Object o2) {
    if (o1 instanceof Object[] && o2 instanceof Object[]) {
      Object[] a1 = (Object[])o1;
      Object[] a2 = (Object[])o2;
      if (a1.length != a2.length) return false;
      for (int i = 0; i < a1.length; i++) if (!compare(a1[i], a2[i])) return false;
    }
    else if (o1 instanceof Vector && o2 instanceof Vector) {
      Vector v1 = (Vector)o1;
      Vector v2 = (Vector)o2;
      if (v1.size() != v2.size()) return false;
      for (int i = 0; i < v1.size(); i++) if (!compare(v1.elementAt(i), v2.elementAt(i))) return false;
    }
    else if (o1 instanceof list && o2 instanceof list) {
      list l1 = (list)o1;
      list l2 = (list)o2;
      if (l1.length() != l2.length()) return false;
      while (!l1.isEmpty()) {
        if (!compare(l1.head(), l2.head())) return false;
        l1 = l1.tail();
        l2 = l2.tail();
      }
    }
    else return o1.equals(o2);
    return true;
  }    

}
