package applications.collages;

import java.awt.geom.*;
import java.awt.*;

public class part implements Cloneable {

  public final static int FILLED  = 0;
  public final static int OUTLINE = 1;

  private int type;
  private GeneralPath outline;
  private Color colour = Color.black;
  private int[] rgb = null;
  private double[] attrValue = null;
  private double thickness = -1;
  private AffineTransform trans = new AffineTransform();
    
  public part(int type, GeneralPath outline) {
    this.type = type;
    this.outline = outline;
  } 
                                                                                
  public synchronized GeneralPath getOutline() {
    if (trans != null) {
      outline = (GeneralPath)outline.clone();
      outline.transform(trans);
      trans = null;
    }
    return outline;
  }
  
  public void setOutline(GeneralPath outline) {
    trans = new AffineTransform();
    this.outline = outline;
  }
  
  public int type() {
    return type;
  }
  
  public void initAttribs(int attribs) {
    attrValue = new double[attribs];
    for (int i = 0; i < attribs; i++) attrValue[i] = 0;
    rgb = new int[3];
  }
  
  public void setRgb(int r, int g, int b) {
    rgb[0] = r;
    rgb[1] = g;
    rgb[2] = b;
    colour = null;
  }
  
  public double[] getAllAttribs() {
    return attrValue;
  }
  
  public void setAttrib(int attrib, double value) {
    attrValue[attrib] = value;
  }
  
  public void setAllAttribs(double[] values) {
    attrValue = values;
  }
  
  public void setColour(float r, float g, float b) {
    colour = new Color(r,g,b);
  }
    
  public void setColour(float grey) {
    colour = new Color(grey,grey,grey);
  }
    
  public synchronized Color getColour() {
    if (colour == null) {
      try {
        return colour
          = new Color(fold(rgb[0]),fold(rgb[1]),fold(rgb[2]));
      } catch (IllegalArgumentException e) {
        return colour = new Color(0,0,0);
      }
    }
    else return colour;
  }

  private float fold(int attr) {
    return (float)colourOperation.fold(attrValue[attr]);
  }
  
  public void setThickness(double thickness) {
    this.thickness = thickness;
  }
  
  public double getThickness() {
    return thickness;
  }

  public void transform(AffineTransform t) {
    if (trans == null) outline.transform(t);
    else trans.preConcatenate(t);
  }
  
  public void changeColour(colourOperation op) {
    if (attrValue != null) {
      op.apply(attrValue);
      colour = null;
    }
  }
  
  public Rectangle2D.Double bounds() {
    Rectangle2D.Double bbox = new Rectangle2D.Double(0,0,0,0);
    bbox.setRect(getOutline().getBounds2D());
    return bbox;
  }

  public double[] largeBounds() {
    double[] bounds = new double[4];
    bounds[0] = bounds[1] = Double.POSITIVE_INFINITY;
    bounds[2] = bounds[3] = Double.NEGATIVE_INFINITY;
    PathIterator it = getOutline().getPathIterator(null);
    double[] coord = new double[6];
    while (!it.isDone()) {
      int count;
      switch (it.currentSegment(coord)) {
        case PathIterator.SEG_MOVETO:
        case PathIterator.SEG_LINETO:
          count = 1;
          break;
        case PathIterator.SEG_QUADTO:
          count = 2;
          break;
        case PathIterator.SEG_CUBICTO:
          count = 3;
          break;
        default:
          count = 0;
          break;
      }
      for (int i = 0; i < count; i++) {
        if (coord[2*i] < bounds[0]) bounds[0] = coord[2*i];
        if (coord[2*i+1] < bounds[1]) bounds[1] = coord[2*i+1];
        if (coord[2*i] > bounds[2]) bounds[2] = coord[2*i];
        if (coord[2*i+1] > bounds[3]) bounds[3] = coord[2*i+1];
      }
      it.next();
    }
    return bounds;
  }    
  
  public synchronized Object clone() {
    try {
      part result = (part)super.clone();
      if (rgb != null) {
        result.rgb = (int[])rgb.clone();
        result.attrValue = (double[])attrValue.clone();
      }
      if (trans == null) trans = new AffineTransform();
      else result.trans = (AffineTransform)trans.clone();
      return result;
    }
    catch (CloneNotSupportedException e) {
      throw new InternalError();
    }
  }
  
}
