package applications.lineDrawings;

import java.util.*;
import util.*;

public class lineDrawing {

  public static int branch = 1;
  public static int filledPolygon = 2;
  
  public Object specialInfo = null;
  private int specialType = 0;

  private list lines = new list();
  private list end;
  private double xEndpoint;
  private double yEndpoint;
  

  public lineDrawing() {
    end = lines;
    xEndpoint = 0;
    yEndpoint = 0;
  }
  
  public lineDrawing(line l) {
    lines.append(l);
    end = lines.tail();
    xEndpoint = l.x2;
    yEndpoint = l.y2;
  }
  
  public lineDrawing(lineDrawing d, int type, Object info) {
    lines.append(d);
    end = lines.tail();
    xEndpoint = d.xEndpoint;
    yEndpoint = d.yEndpoint;
    d.specialInfo = info;
    d.specialType = type;
  }
  
  public double getEndpointX() { return xEndpoint; }
  
  public double getEndpointY() { return yEndpoint; }
  
  public void setEndpoint(double x, double y) {
    xEndpoint = x;
    yEndpoint = y;
  }

/** Append another line drawing to this one.
  * This is a destructive operation that - for efficiency reasons -
  * does not copy the argument. Instead, the argument line drawing
  * is translated to this line's endpoint and then appended to it.
  */
  public void concat(lineDrawing d) {
    if (!d.lines.isEmpty()) {
      end.concat(d.lines);
      end = d.end;
      Enumeration lines = d.elements(flatten, flatten);
      while (lines.hasMoreElements()) {
        line l = (line)lines.nextElement();
        l.x1 += xEndpoint;
        l.y1 += yEndpoint;
        l.x2 += xEndpoint;
        l.y2 += yEndpoint;
      }
    }
    xEndpoint += d.xEndpoint;
    yEndpoint += d.yEndpoint;
  }

/** Take the union of this drawing and another one.
  * The endpoint of this drawing is not affected.
  * For efficiency reasons this operation does not take copies!
  */
  public void union(lineDrawing d) {
    if (!d.lines.isEmpty()) {
      end.concat(d.lines);
      end = d.end;
    }
  }
  
/** Hide all lines of this line drawing.
  * This removes filled polygons as well.
  */
  public void hideLines() {
    list curr = lines;
    while (!curr.isEmpty()) {
      if (curr.head() instanceof line) ((line)curr.head()).hidden = true;
      else {
        lineDrawing d = (lineDrawing)curr.head();
        d.hideLines();
        if (d.specialType == filledPolygon) {
          if (!curr.tail().isEmpty()) d.lines.concat(curr.tail());
          else end = d.end;
          curr.removeAllElements();
          curr.concat(d.lines);
          continue;
        }
      }
      curr = curr.tail();
    }
  }
  
  public void rotate(double angle) {
    double cos = Math.cos(angle);
    double sin = Math.sin(angle);
    double x;
    Enumeration lines = elements(flatten, flatten);
    while (lines.hasMoreElements()) {
      line l = (line)lines.nextElement();
      x = cos*l.x1 - sin*l.y1;
      l.y1 = sin*l.x1 + cos*l.y1;
      l.x1 = x;
      x = cos*l.x2 - sin*l.y2;
      l.y2 = sin*l.x2 + cos*l.y2;
      l.x2 = x;
    }
    x = cos*xEndpoint - sin*yEndpoint;
    yEndpoint = sin*xEndpoint + cos*yEndpoint;
    xEndpoint = x;
  }
  
  public void scale(double factorX, double factorY) {
    Enumeration lines = elements(flatten,flatten);
    while (lines.hasMoreElements()) {
      line l = (line)lines.nextElement();
      l.x1 *= factorX;
      l.x2 *= factorX;
      l.y1 *= factorY;
      l.y2 *= factorY;
    }
    xEndpoint *= factorX;
    yEndpoint *= factorY;
  }
  
  public static int returnAsIs = 0;
  public static int flatten = 1;
  public static int skip = 2;
  
  public Enumeration elements(int polyAction, int branchAction) {
    return new enumeration(polyAction, branchAction);
  }
  
  private class enumeration implements Enumeration {

    private list current = lines;
    private list continuation = null;
    private int polyAction;
    private int branchAction;
    
    public enumeration(int polyAction, int branchAction) {
      this.polyAction = polyAction;
      this.branchAction = branchAction;
      continuation = new list();
      seekNext();
    }
    
    public boolean hasMoreElements() { return !current.isEmpty(); }
    
    public Object nextElement() {
      Object result = current.head();
      current = current.tail();
      seekNext();
      return result;
    }
    
    private void seekNext() {
      while (true) {
        if (current.isEmpty() && !continuation.isEmpty()) {
          current = (list)continuation.head();
          continuation = continuation.tail();
        }
        else if (!current.isEmpty() && current.head() instanceof lineDrawing) {
          lineDrawing d = (lineDrawing)current.head();
          int action = (d.specialType == filledPolygon) ?
                       polyAction : branchAction;
          if (action == flatten) {
            continuation.prepend(current.tail());
            current = ((lineDrawing)current.head()).lines;
          }
          else if (action == skip) {
            current = current.tail();
          }
          else break; // action == returnAsIs
        }
        else break;
      }
    }
  }
  
}
