package applications.lineDrawings;

import algebras.*;
import terms.*;

public  abstract class lineDrawingAlgebra extends extensibleAlgebra {

  private static String vscale = "v-scale"; 
  private static String hscale = "h-scale";
  private static String scale = "scale";
  public static int vtype = 0;
  public static int htype = 1;
  public static int hvtype = 2;
  
  protected Object apply(symbol op, Object[] args) {
    if (args.length == 0) return new lineDrawing();
    lineDrawing result = (lineDrawing)args[0];
    for (int i = 1; i < args.length; i++) result.concat((lineDrawing)args[i]);
    Object o = operationOf(op);
    if (o != null && o instanceof operation) {
      operation scaleOp = (operation)o;
      result.scale(scaleOp.type == vtype ? 1 : scaleOp.factor,
                    scaleOp.type == htype ? 1 : scaleOp.factor);
    }
    return result;
  }
  
  protected Object extendBy(symbol s) {
    operation op;
    double factor;
    String name = s.toString();
    String number;
    if (name.startsWith(vscale)) {
      op = new operation(vtype);
      number = name.substring(vscale.length());
    }
    else if (name.startsWith(hscale)) {
      op = new operation(htype);
      number = name.substring(hscale.length());
    }
    else if (name.startsWith(scale)) {
      op = new operation(hvtype);
      number = name.substring(scale.length());
    }
    else return null;
    try { factor = Double.valueOf(number).doubleValue(); }
    catch (NumberFormatException e) { return null; }
    if (factor < 0) return null;
    else op.factor = factor;
    return op;
  }
  
  private class operation {
    public int type;
    public double factor;
    public operation(int type) { this.type = type; }
  }

}
