package generators;

import java.util.*;
import terms.*;

public class sortManager {

  private Vector symbols = new Vector(10);
  private Hashtable sortIndex = new Hashtable(10);
  
  private sortedSymbol get(int i, int j) {
    Vector theSort;
    if (i < symbols.size()) theSort = (Vector)symbols.elementAt(i);
    else return null;
    if (j < theSort.size()) return (sortedSymbol)theSort.elementAt(j);
    else return null;
  }
  
  public void addSymbol(String name, String resultSort, String[] argSort, double weight) {
    int result = findSort(resultSort);
    int[] arg = new int[argSort.length];
    for (int i = 0; i < argSort.length; i++) arg[i] = findSort(argSort[i]);
    Vector thisSort = (Vector)symbols.elementAt(result);
    thisSort.addElement(new sortedSymbol(name, result, arg, thisSort.size(), weight));
  }
  
  public int findSort(String sortName) {
    Object index = sortIndex.get(sortName);
    if (index != null) return ((Integer)index).intValue();
    else {
      int newIndex = symbols.size();
      sortIndex.put(sortName, new Integer(newIndex));
      Vector newSort = new Vector(10);
      newSort.addElement(new sortedSymbol(sortName, newIndex, new int[0], 0, 0));
      symbols.addElement(newSort);
      return newIndex;
    }
  }
  
  public int sortIndex(symbol sym) {
    return ((sortedSymbol)sym).resultSort;
  }
  
  public int sortIndex(symbol sym, int index) {
    return ((sortedSymbol)sym).argSort[index];
  }
  
  public  symbol sortSymbol(int index) {
    return get(index, 0);
  }
  
  public symbol firstSymbol(int sort) {
    return get(sort, 1);
  }
  
  public symbol nextSymbol(symbol curr) {
    return get(((sortedSymbol)curr).resultSort, ((sortedSymbol)curr).index + 1);
  }
  
  public boolean isSort(symbol s) {
    return ((sortedSymbol)s).index == 0;
  }
  
  public int numberOfSorts() {
    return symbols.size();
  }
  
  public double getWeight(symbol s) {
    return ((sortedSymbol)s).weight;
  }
  
  public double getMinDepth(symbol s) {
    return ((sortedSymbol)s).minDepth;
  }
  
  public void initMinDepths() {
    boolean changed;
    do {
      changed = false;
      for (int i = 0; i < numberOfSorts(); i++) {
        Vector theSort = (Vector)symbols.elementAt(i);
        for (int j = 1; j < theSort.size(); j++) {
          sortedSymbol s = (sortedSymbol)theSort.elementAt(j);
          int depth = -1;
          for (int k = 0; k < s.argSort.length; k++) {
            depth = Math.max(depth, get(s.argSort[k], 0).minDepth);
          }
          if (depth == Integer.MAX_VALUE || ++depth == s.minDepth) continue;
          changed = true;
          s.minDepth = depth;
          sortedSymbol sort = get(s.resultSort, 0);
          sort.minDepth = Math.min(sort.minDepth, depth);
        }
      }
    } while (changed);
  }

  private class sortedSymbol extends symbol {
  
    public int resultSort;
    public int[] argSort;
    public int index;
    public double weight;
    public int minDepth = Integer.MAX_VALUE;
    
    public sortedSymbol(String name, int resultSort, int[] argSort, int index, double weight) {
      super(name, argSort.length);
      this.resultSort = resultSort;
      this.argSort = (int[])argSort.clone();
      this.index = index;
      this.weight = weight;
    }
      
  }
  
}

