package generators;

import terms.*;
import parsers.*;
import gui.*;
import util.*;

/** A (possibly non-deterministic) device that produces terms as output.
  * Subclasses should implement some commands by which the behaviour can
  * be controlled interactively.
  */
public abstract class treeGenerator extends parsable implements reactive {

/** Returns the last term generated. */
  public abstract term currentTerm();
  
/** The default implementation of the method <code>commands</code>
  * yields the empty list.
  */
  public list commands() { return new list(); }
  
/** The default implementation of the method <code>execute</code>
  * does nothing.
  */
  public void execute(String command) { }

/** The default <code>requestsExit</code> method returns <code>false</code>.
  */
  public boolean requestsExit(String command) { return false; }

  
}
