package gui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;


public class jcanvas extends JPanel implements MouseListener {

  /**
	 * 
	 */
  private static final long serialVersionUID = 297642568088007737L;
  private double scaling = 1;
  private boolean scalingEnabled = true;
  private Point lastPressed = null;
  private Point firstPressed = null;
  private JScrollPane scroll;
  
  public jcanvas() {
    super();
    scroll = new JScrollPane(this);
    addMouseListener(this);
  }
  
  public JScrollPane getScrollPane() {
    return scroll;
  }

  public double getScaling() { return scaling; }
  
  public void setScaling(double newScaling) {
    scaling = newScaling;
  }
  
  public void zoom(double factor) {
    scaling *= factor;
  }
  
  public void disableScaling() {
    scalingEnabled = false;
  }
  
  public void enableScaling() {
    scalingEnabled = true;
  }
  
  public void mouseClicked(MouseEvent e) {}
  
  public void mousePressed(MouseEvent e) {
    if (!(e.isMetaDown() || e.isAltDown())) lastPressed = e.getPoint();
    else if (scalingEnabled) {
      firstPressed = lastPressed = e.getPoint();
      drawSquare(getGraphics());
    }
  }
  
  public void mouseReleased(MouseEvent e) {
    if (lastPressed != null) {
      if (!(e.isMetaDown() || e.isAltDown())) lastPressed = null;
      else if (scalingEnabled && firstPressed != null) {
        drawSquare(getGraphics());
        firstPressed = lastPressed = null;
        repaint();
      }
    }
  }
  
  public void mouseEntered(MouseEvent e) {}
  
  public void mouseExited(MouseEvent e) {}
  
  private void drawSquare(Graphics g) {
    g.setColor(Color.black);
    g.setXORMode(Color.white);
    g.drawRect((int)Math.min(firstPressed.x, lastPressed.x),
                    (int)Math.min(firstPressed.y, lastPressed.y),
                    (int)Math.abs(lastPressed.x - firstPressed.x),
                    (int)Math.abs(lastPressed.y - firstPressed.y));
  }
  
}
