package gui.nodeTypes;

import terms.*;
import generators.*;
import parsers.*;

public class treeGeneratorNode extends worksheetNode {

  /**
	 * 
	 */
  private static final long serialVersionUID = -3032528537829449328L;
  protected term curr = null;

  public treeGeneratorNode(parsable obj, String fileName) {
    super(obj, fileName);
  }

  public void initialize() throws ParseException {
    curr = ((treeGenerator)contents).currentTerm();
  }
  
  protected synchronized Object current() { return curr; }
  
  public void runContents(Object command, int type) {
    super.runContents(command, type);
    setChanged();
    synchronized (this) { curr = ((treeGenerator)contents).currentTerm(); }
    broadcastResult(curr);
  }
  
  protected void reinit(parsable newContents) {
    super.reinit(newContents);
    curr = ((treeGenerator)contents).currentTerm();
  }
  
}
