/* Generated By:JavaCC: Do not edit this line. mtTransducerParser.java */
package parsers;

import java.util.*;
import terms.*;
import generators.*;


/**
 * Parser for Macro Tree Transducers
 */
public class mtTransducerParser implements mtTransducerParserConstants {
    private ASCII_CharStream inputStream = null;

    /* The MTT definition */
    public finiteSignature in;
    public finiteSignature out;
    public finiteSignature states;
    public symbol initial;
    /* Rules */
    protected rulesParser rules;
    public term[][] rule = new term[0][];
    public double[] weight = new double[0];
    /* Options */
    public boolean performance = false;

    /**
     * Constructor, receives input stream from mtTransducer class
     */
    public mtTransducerParser(ASCII_CharStream input) {
        this(new mtTransducerParserTokenManager(input));
        rules = new rulesParser(input);
        inputStream = input;
    }

    /**
     * Parse MTT rules, lhs --> rhs
     */
    private class rulesParser extends trsParser {

        public rulesParser(ASCII_CharStream input) {
            super(input, true);
        }

        protected void insertRule(term lhs, term rhs, double wght) throws ParseException {
            verifyRule(lhs, rhs);
            term[][] old = rule;
            rule = new term[old.length + 1][];
            System.arraycopy(old, 0, rule, 0, old.length);
            rule[old.length] = new term[2];
            rule[old.length][0] = lhs;
            rule[old.length][1] = rhs;
            double[] oldWeight = weight;
            weight = new double[oldWeight.length + 1];
            System.arraycopy(oldWeight, 0, weight, 0, oldWeight.length);
            weight[oldWeight.length] = wght;
        }

        protected void verifyRule(term lhs, term rhs) throws ParseException {
            //BitSets specifies which variables and parameters where found
            //in the lhs
            BitSet lhsVars = new BitSet();
            BitSet lhsPars = new BitSet();
            verifyLhs(lhs, lhsVars, lhsPars);
            verifyRhs(rhs, lhsVars, lhsPars);
        }

        /**
         * Make sure that the lhs is of the type
         *      q(a(x1,...,xm),y1,...,yn)
         * Lhs must follow the formal definitions (e.g. rank must be correct)
         */
        private void verifyLhs(term lhs, BitSet vars, BitSet pars)
            throws ParseException {

            symbol sym = lhs.topSymbol();
            //q must be in Q
            if (!(states.contains(sym)))
            {
                throw new ParseException("Rule " + (rule.length+1) +
                        ": Topmost symbol " + sym +
                        " of left-hand side not a state.");
            }
            //a must be in sigma (input alphabet)
            term xPart = lhs.subterm(0);
            sym = xPart.topSymbol();
            if (!in.contains(sym))
                throw new ParseException("Rule " + (rule.length+1) +
                        ": Symbol " + sym + " of rank " +
                        sym.rank() +
                        " in left-hand side not in input signature");
            //x1, ..., xm must be input variables
            symbol sigma = xPart.topSymbol();
            for (int i = 0; i < sigma.rank(); i++) {
                sym = xPart.subterm(i).topSymbol();
                if (!(sym instanceof variable))
                    throw new ParseException("Rule " + (rule.length+1) +
                            ": Symbol " + sym.toString() +
                            " in left-hand side not a variable");
                else
                {
                    //Add to variable bitset
                    if (vars.get(((variable)sym).index()))
                        throw new ParseException("Rule " + (rule.length+1) +
                                ": Variable " + sym.toString() +
                                " occurs more than once in left-hand side");
                    else
                        vars.set(((variable)sym).index());
                }
            }

            //y1, ..., yn must be formal parameters
            symbol currentState = lhs.topSymbol();
            for (int i = 1; i < currentState.rank(); i++) {
                sym = lhs.subterm(i).topSymbol();
                if (!(sym instanceof parameter))
                    throw new ParseException("Rule " + (rule.length+1) +
                            ": Symbol " + sym.toString() +
                            " in left-hand side not a formal parameter");
                else
                {
                    if (pars.get(((parameter)sym).index()))
                        throw new ParseException("Rule " + (rule.length+1) +
                                ": Parameter " + sym.toString() +
                                " occurs more than once in left-hand side");
                    else
                        pars.set(((parameter)sym).index());
                }
            }
        }

        /**
         * Check the rhs. Valid rhs (t) are recursively defined as
         * (i)   t -> f(t1, ... , tk)
         * (ii)    |  yi                   (yi must be in pars)
         * (iii)   |  q(xj, t1, ..., tk)   (xj must be in vars)
         */
        private void verifyRhs(term rhs, BitSet vars, BitSet pars)
            throws ParseException {

            symbol top = rhs.topSymbol();

            //Check if this is (i)
            if (out.contains(top)) {
                //Recursively check t1, ... , tk
                for (int i = 0; i < top.rank(); i++)
                    verifyRhs(rhs.subterm(i), vars, pars);
            }

            //Check if this is (ii)
            else if (top instanceof parameter) {
                //If yi is in pars, then it is ok
                if (!pars.get( ((parameter)top).index() )) {
                    throw new ParseException("Rule " + (rule.length+1) +
                            ": Parameter " + top.toString() +
                            " appears in rhs but not in lhs");
                }
            }

            //Check if this is (iii)
            else if (states.contains(top) && top.rank() > 0) {
                //Is xj in vars?
                symbol xVar = (rhs.subterm(0)).topSymbol();
                if (!(xVar instanceof variable))
                    throw new ParseException("Rule " + (rule.length+1) +
                            ": Symbol " + xVar.toString() +
                            " in rhs is not a variable");

                if (!vars.get( ((variable)xVar).index() )) {
                    throw new ParseException("Rule " + (rule.length+1) +
                            ": Variable " + xVar.toString() +
                            " appears in rhs but not in lhs");
                }
                //Recursively check t1, ... , tk
                for (int i = 1; i < top.rank(); i++)
                    verifyRhs(rhs.subterm(i), vars, pars);
            }
            //If none of (i), (ii) or (iii) then illegal symbol
            else {
                throw new ParseException("Rule " + (rule.length+1) +
                        ": Symbol " + top.toString() +
                        " of rank " + top.rank() + " in rhs can not be used " +
                        "in this context");
            }


        }
    }

/**
 * Parse a Macro Tree Transducer
 */
  final public void mtTransducer() throws ParseException {
    jj_consume_token(LEFT_PAR);
        in = new finiteSignature();
        in.parse(inputStream);
    jj_consume_token(COMMA);
        out = new finiteSignature();
        out.parse(inputStream);
    jj_consume_token(COMMA);
        states = new finiteSignature();
        states.parse(inputStream);
        if ( !states.disjointWith(in) ) {
            {if (true) throw new ParseException("Input alphabet must be disjoint with the set of states");}
        }
        if ( !states.disjointWith(out) ) {
            {if (true) throw new ParseException("Output alphabet must be disjoint with the set of states");}
        }
    jj_consume_token(COMMA);
        rules.rules();
    jj_consume_token(COMMA);
        nameParser names = new nameParser(inputStream);
        initial = new symbol(names.name(), 1);
        if (!states.contains(initial)) {
            {if (true) throw new ParseException("Initial state must be a symbol of rank 1 and exist in the state set");}
        }
    jj_consume_token(RIGHT_PAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      jj_consume_token(PERFORMANCEKEY);
        performance = true;
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
  }

  public mtTransducerParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[1];
  final private int[] jj_la1_0 = {0x100,};

  public mtTransducerParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new mtTransducerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public mtTransducerParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new mtTransducerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public mtTransducerParser(mtTransducerParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(mtTransducerParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[10];
    for (int i = 0; i < 10; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 1; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 10; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
