package terms;

import java.util.*;
import parsers.*;

/** A finite signature.
  * Having different symbols with the same name is allowed.
  */
public class finiteSignature implements signature, Cloneable {

  private Hashtable symbols = new Hashtable();
  private int elemCount = 0;
  
/** Adds a symbol to a signature.
  */
  public void addSymbol(symbol s) {
    symbols.put(s, new Integer(elemCount++));
  }
  
/** Removes a symbol from a signature.
  */
  public void removeSymbol(symbol s) {
    symbols.remove(s);
  }
  
/** The number of symbols in this signature.
  */
  public int size() {
    return symbols.size();
  }
  
  public boolean contains(symbol sym) {
    return symbols.containsKey(sym);
  }
  
  public int indexOf(symbol sym) {
    return ((Integer)symbols.get(sym)).intValue();
  }
  
  public int maxIndex() {
    return elemCount;
  }
  
/** Test whether another signature is disjoint with this one. */
  public boolean disjointWith(signature sig) {
    Enumeration enm = symbols.keys();
    while (enm.hasMoreElements()) {
      if (sig.contains((symbol)enm.nextElement())) return false;
    }
    return true;
  }
  
/** Add all symbols of another finite signature to this one. */
  public void unionWith(finiteSignature sig) {
    Enumeration enm = sig.elements();
    while (enm.hasMoreElements()) addSymbol((symbol)enm.nextElement());
  }
  
/** An enumeration of all the symbols in the signature. */
  public Enumeration elements() { return symbols.keys(); }
  
  public String toString() {
    StringBuffer result = new StringBuffer();
    result.append("{ ");
    Enumeration elem = elements();
    if (elem.hasMoreElements()) {
      symbol sym = (symbol)elem.nextElement();
      result.append(nameParser.unparse(sym.toString()) + ":" + sym.rank());
      while (elem.hasMoreElements()) {
        sym = (symbol)elem.nextElement();
        result.append(", " + nameParser.unparse(sym.toString()) + ":" + sym.rank());
      }
    }
    result.append(" }");
    return result.toString();
  }

/** Parse a signature definition.
    @exception ParseException if an error occurs
  */
  public void parse(ASCII_CharStream stream) throws ParseException {
    setParser parser = new setParser(stream);
    parser.set(new cp(new symbolParser(stream)));
  }
  
  private class cp implements componentParser {
    private symbolParser symbols;
    public cp(symbolParser symbols) { this.symbols = symbols; }
    public void component() throws ParseException { addSymbol(symbols.symbol()); }
  }

  public Object clone() {
    finiteSignature result;
    try { result = (finiteSignature)super.clone(); }
    catch (CloneNotSupportedException e) // cannot happen (hopefully)
      { throw new InternalError(e.toString()); }
    result.symbols = (Hashtable)symbols.clone();
    return result;
  }

}
