package terms;

import java.util.*;
import parsers.*;

/** A finite signature all symbols of which have the same rank. */
public class fixedRankSignature extends finiteSignature {

  private int rank;
  
  public fixedRankSignature(int rank) {
    super();
    this.rank = rank;
  }
  
/** Adds a symbol to the signature.
  * An already defined symbol with the same name is overwritten.
  * If the rank does not fit, it is corrected.
  */
  public void addSymbol(symbol s) {
    if (s.rank() != rank) super.addSymbol(new symbol(s.toString(), rank));
    else super.addSymbol(s);
  }
  
/** Adds a symbol to the signature.
  */
  public void addSymbol(String name) {
    super.addSymbol(new symbol(name, rank));
  }
  
  public String toString() {
    StringBuffer result = new StringBuffer();
    result.append("{ ");
    Enumeration elem = elements();
    if (elem.hasMoreElements()) {
      result.append(nameParser.unparse(elem.nextElement().toString()));
      while (elem.hasMoreElements()) result.append(", " + nameParser.unparse(elem.nextElement().toString()));
    }
    result.append(" }");
    return result.toString();
  }
  
/** Parse a signature definition.
    @exception ParseException if an error occurs
  */
  public void parse(ASCII_CharStream stream) throws ParseException {
    setParser parser = new setParser(stream);
    parser.set(new cp(new nameParser(stream)));
  }
  
  private class cp implements componentParser {
    private nameParser names;
    public cp(nameParser names) { this.names = names; }
    public void component() throws ParseException { addSymbol(names.name()); }
  }

}
