/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_06;

import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.ViewEntryCollection;

public class CollectionDemo {
    private static final boolean localOrRemote = true;
    private static final String LOCALPASSWORD = "1geheim";
    private static final String REMOTEPASSWORD = "geheim";
    private static final String REMOTEUSER = "Thomas Ekert/DJBUCH";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        Database db = null;
        Session session = null;
        try {
            try {
                NotesThread.sinitThread();
                session = NotesFactory.createSession(null, null, (String)LOCALPASSWORD);
                db = session.getDatabase("", "djbuch/djbuch.nsf");
                DemoTools.startup(db, 20);
                int count1 = CollectionDemo.dumpDatabase(db);
                int count2 = CollectionDemo.dumpView(db, "V_lookup_k6", null);
                int count3 = CollectionDemo.dumpView(db, "V_lookup_k6", "FIELD F_category=Wombats");
                int count4 = CollectionDemo.updateView(db, "V_lookup_k6", "FIELD F_category=Wombats", "F_newField", "value", false);
                int count5 = CollectionDemo.updateView(db, "V_lookup_k6", "FIELD F_category=Wombats", "F_newField", "value", true);
                int count6 = CollectionDemo.deleteFromView(db, "V_lookup_k6", "FIELD F_category=Wombats", false);
                System.out.println(String.valueOf(count1) + " / " + count2 + " / " + count3 + " / " + count4 + " / " + count5 + " / " + count6);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e instanceof NotesException ? "id = " + ((NotesException)((Object)e)).id : "");
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            GC.recycle(db);
            GC.recycle(session);
            NotesThread.stermThread();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        GC.recycle(db);
        GC.recycle(session);
        NotesThread.stermThread();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int dumpDatabase(Database db) throws NotesException {
        int size;
        Document nextDoc;
        Document doc;
        DocumentCollection dc;
        block6: {
            block5: {
                dc = null;
                doc = null;
                nextDoc = null;
                int count = 1;
                size = 0;
                try {
                    dc = db.getAllDocuments();
                    if (dc == null) {
                        Object var6_6 = null;
                        break block5;
                    }
                    size = dc.getCount();
                    doc = dc.getFirstDocument();
                    while (doc != null) {
                        System.out.println("Dokument " + count++ + " / " + size);
                        CollectionDemo.dumpDoc(doc);
                        nextDoc = dc.getNextDocument();
                        GC.recycle(doc);
                        doc = nextDoc;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    GC.recycle(doc);
                    GC.recycle(nextDoc);
                    GC.recycle(dc);
                    throw throwable;
                }
            }
            GC.recycle(doc);
            GC.recycle(nextDoc);
            GC.recycle(dc);
            return -1;
        }
        Object var6_8 = null;
        GC.recycle(doc);
        GC.recycle(nextDoc);
        GC.recycle(dc);
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int dumpView(Database db, String viewName, String query) throws NotesException {
        int size;
        Document nextDoc;
        Document doc;
        View view;
        block7: {
            block6: {
                view = null;
                doc = null;
                nextDoc = null;
                int count = 1;
                size = 0;
                try {
                    view = db.getView(viewName);
                    if (view == null) {
                        Object var8_8 = null;
                        break block6;
                    }
                    if (query != null) {
                        view.FTSearch(query);
                    }
                    size = view.getAllEntries().getCount();
                    doc = view.getFirstDocument();
                    while (doc != null) {
                        System.out.println("Dokument " + count++ + " / " + size);
                        CollectionDemo.dumpDoc(doc);
                        nextDoc = view.getNextDocument(doc);
                        GC.recycle(doc);
                        doc = nextDoc;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    GC.recycle(doc);
                    GC.recycle(nextDoc);
                    GC.recycle(view);
                    throw throwable;
                }
            }
            GC.recycle(doc);
            GC.recycle(nextDoc);
            GC.recycle(view);
            return -1;
        }
        Object var8_10 = null;
        GC.recycle(doc);
        GC.recycle(nextDoc);
        GC.recycle(view);
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int deleteFromView(Database db, String viewName, String query, boolean allInOne) throws NotesException {
        int size;
        Document nextDoc;
        Document doc;
        View view;
        block9: {
            block8: {
                view = null;
                doc = null;
                nextDoc = null;
                int count = 1;
                size = 0;
                try {
                    view = db.getView(viewName);
                    if (view == null) {
                        Object var10_9 = null;
                        break block8;
                    }
                    if (query != null) {
                        view.FTSearch(query);
                    }
                    size = view.getAllEntries().getCount();
                    if (allInOne) {
                        view.getAllEntries().removeAll(true);
                    }
                    doc = view.getFirstDocument();
                    while (doc != null) {
                        System.out.println("Dokument " + count++ + " / " + size);
                        nextDoc = view.getNextDocument(doc);
                        boolean someExtraCondition = doc.hasItem("Item_0");
                        if (someExtraCondition) {
                            doc.remove(true);
                        }
                        GC.recycle(doc);
                        doc = nextDoc;
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    GC.recycle(doc);
                    GC.recycle(nextDoc);
                    GC.recycle(view);
                    throw throwable;
                }
            }
            GC.recycle(doc);
            GC.recycle(nextDoc);
            GC.recycle(view);
            return -1;
        }
        Object var10_11 = null;
        GC.recycle(doc);
        GC.recycle(nextDoc);
        GC.recycle(view);
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int updateView(Database db, String viewName, String query, String name, String value, boolean allInOne) throws NotesException {
        int size;
        Document nextDoc;
        Document doc;
        ViewEntryCollection vec;
        View view;
        block9: {
            block8: {
                view = null;
                vec = null;
                doc = null;
                nextDoc = null;
                int count = 1;
                size = 0;
                try {
                    view = db.getView(viewName);
                    if (view == null) {
                        Object var13_12 = null;
                        break block8;
                    }
                    if (query != null) {
                        view.FTSearch(query);
                    }
                    vec = view.getAllEntries();
                    size = vec.getCount();
                    if (allInOne) {
                        vec.stampAll(name, (Object)value);
                        break block9;
                    }
                    boolean remindAutoUpdateStatus = view.isAutoUpdate();
                    view.setAutoUpdate(false);
                    doc = view.getFirstDocument();
                    while (true) {
                        if (doc == null) {
                            view.setAutoUpdate(remindAutoUpdateStatus);
                            view.refresh();
                            break block9;
                        }
                        System.out.println("Dokument " + count++ + " / " + size);
                        doc.replaceItemValue(name, (Object)("individuell " + count + " / " + value));
                        nextDoc = view.getNextDocument(doc);
                        GC.recycle(doc);
                        doc = nextDoc;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    GC.recycle(doc);
                    GC.recycle(nextDoc);
                    GC.recycle(vec);
                    GC.recycle(view);
                    throw throwable;
                }
            }
            GC.recycle(doc);
            GC.recycle(nextDoc);
            GC.recycle(vec);
            GC.recycle(view);
            return -1;
        }
        Object var13_14 = null;
        GC.recycle(doc);
        GC.recycle(nextDoc);
        GC.recycle(vec);
        GC.recycle(view);
        return size;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void dumpDoc(Document doc) throws NotesException {
        Item item = null;
        try {
            Vector allItems = doc.getItems();
            int i = 0;
            while (i < allItems.size()) {
                item = (Item)allItems.elementAt(i);
                if (item.getType() == 1280) {
                    System.out.println(String.valueOf(item.getName()) + " = " + item.getValueString());
                }
                GC.recycle(item);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            GC.recycle(item);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        GC.recycle(item);
    }
}

