/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_06;

import djbuch.kapitel_06.DJLoopCommand;
import djbuch.kapitel_06.GC;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;

public class DJLoopExecutor {
    private final DJLoopCommand command;
    private static final String EXCEPTION_NOTYPE = "Command hat falschen Typ.";
    private static final int EXCEPTION_NO = 999;

    public DJLoopExecutor(DJLoopCommand command) {
        this.command = command;
    }

    public void doLoop() throws NotesException {
        switch (this.command.getType()) {
            case 2: {
                this.doLoopView();
                break;
            }
            case 1: 
            case 3: {
                this.doLoopCollection();
                break;
            }
            default: {
                throw new NotesException(999, EXCEPTION_NOTYPE);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doLoopView() throws NotesException {
        Document doc = null;
        Document nextDoc = null;
        try {
            doc = this.command.getView().getFirstDocument();
            while (doc != null && this.command.execute(doc)) {
                nextDoc = this.command.getView().getNextDocument(doc);
                GC.recycle(doc);
                doc = nextDoc;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            GC.recycle(doc);
            GC.recycle(nextDoc);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        GC.recycle(doc);
        GC.recycle(nextDoc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doLoopCollection() throws NotesException {
        DocumentCollection dc;
        Document nextDoc;
        Document doc;
        block6: {
            block5: {
                doc = null;
                nextDoc = null;
                dc = null;
                try {
                    DocumentCollection documentCollection = dc = this.command.getType() == 1 ? this.command.getDatabase().getAllDocuments() : this.command.getCollection();
                    if (dc == null) {
                        Object var4_4 = null;
                        break block5;
                    }
                    doc = dc.getFirstDocument();
                    while (doc != null && this.command.execute(doc)) {
                        nextDoc = dc.getNextDocument();
                        GC.recycle(doc);
                        doc = nextDoc;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    GC.recycle(doc);
                    GC.recycle(nextDoc);
                    if (this.command.getType() != 1) throw throwable;
                    dc.recycle();
                    throw throwable;
                }
            }
            GC.recycle(doc);
            GC.recycle(nextDoc);
            if (this.command.getType() != 1) return;
            dc.recycle();
            return;
        }
        Object var4_6 = null;
        GC.recycle(doc);
        GC.recycle(nextDoc);
        if (this.command.getType() != 1) return;
        dc.recycle();
    }
}

