/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_06;

import djbuch.kapitel_06.GC;
import djbuch.kapitel_07.DJCacheDocument;
import java.io.File;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.Name;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.ViewEntry;
import lotus.domino.ViewNavigator;

public class DemoTools {
    private static final int NUM_OF_DOC_ITEMS = 10;
    private static final int SIZE_OF_DOC_ITEMS = 100;
    public static final boolean RANDOM_INDEX = false;
    private static final boolean FULLTEXT_INDEX = true;
    private static final Random generator = new Random(System.currentTimeMillis());
    public static final String ANIMAL_A = "Tier ";
    private static final String ANIMAL_B = "Am\u00f6be ";
    protected static final String[] CATEGORIES = new String[]{"Wombats", "Hunde", "Katzen", "M\u00e4use", "Tiere\\Gro\u00df", "Tiere\\Klein", "Esel", "K\u00f6nigsberger Tigerforellen"};

    public static final boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.equals("");
    }

    public static final String getServerName(Session mSession) {
        return DemoTools.getServerName(mSession, false);
    }

    public static final String getServerName(Session mSession, boolean abbreviated) {
        try {
            String servername = null;
            Name n = mSession.getUserNameObject();
            if (n.isHierarchical()) {
                servername = abbreviated ? n.getAbbreviated() : n.getCanonical();
            } else {
                System.err.println("Konnte den Servernamen nicht kanonisch aufloesen.");
            }
            return servername;
        }
        catch (NotesException e) {
            e.printStackTrace();
            return "Exception_noServerFound";
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startup(Database db, int numberOfDocs) throws NotesException {
        DemoTools.cleanup(db);
        Document doc = null;
        try {
            System.out.println("Erzeuge " + (numberOfDocs + numberOfDocs / 100) + " neue Dokumente.");
            int i = 0;
            while (true) {
                if (i >= numberOfDocs) break;
                String index = "" + i;
                doc = DemoTools.createDoc(db, CATEGORIES[i % CATEGORIES.length], ANIMAL_A + index, null);
                GC.recycle(doc);
                ++i;
            }
            i = 0;
            while (true) {
                block5: {
                    if (i < numberOfDocs / 100) break block5;
                    System.out.println("FT Index aktualisieren.");
                    db.updateFTIndex(true);
                    break;
                }
                doc = DemoTools.createDoc(db, CATEGORIES[i % CATEGORIES.length], ANIMAL_B + i, null);
                GC.recycle(doc);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            GC.recycle(doc);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        GC.recycle(doc);
    }

    public static Document createDoc(Database db, String cat, String title, Document parent) throws NotesException {
        return DemoTools.createDoc(db, "FO_dokument_k6", cat, title, parent);
    }

    public static Document createDoc(Database db, String form, String cat, String title, Document parent) throws NotesException {
        Document doc = db.createDocument();
        doc.replaceItemValue("Form", (Object)form);
        doc.replaceItemValue("F_Category", (Object)cat);
        doc.replaceItemValue("F_titel", (Object)title);
        doc.replaceItemValue("F_marker_k6", (Object)new Integer(1));
        int i = 0;
        while (i < 10) {
            doc.replaceItemValue("Item_" + i, (Object)DemoTools.getRandomString(100));
            ++i;
        }
        if (parent != null) {
            doc.makeResponse(parent);
        }
        doc.save(true, false);
        return doc;
    }

    public static final void dumpDoc(Document doc) throws NotesException {
        Vector v = doc.getItems();
        int i = 0;
        int s = v.size();
        while (i < s) {
            Item item = (Item)v.elementAt(i);
            System.out.print(" " + item.getName() + "=");
            Vector val = item.getValues();
            System.out.println(val != null ? val.toString() : "null");
            ++i;
        }
    }

    public static final void dumpDoc(Document doc, PrintWriter out) throws NotesException {
        Vector v = doc.getItems();
        int i = 0;
        int s = v.size();
        while (i < s) {
            Item item = (Item)v.elementAt(i);
            out.print(" " + item.getName() + "=");
            Vector val = item.getValues();
            out.println(val != null ? val.toString() : "null");
            ++i;
        }
    }

    public static boolean exists(String fileName) {
        File f = new File(fileName);
        return f.exists();
    }

    public static boolean makeDir(String dirName) {
        File d = new File(dirName);
        if (d.exists() && !d.isDirectory()) {
            return false;
        }
        if (d.exists() && d.isDirectory()) {
            return true;
        }
        return d.mkdirs();
    }

    /*
     * Exception decompiling
     */
    private static final void cleanup(Database db) throws NotesException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 75->79)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final int whichPowerOfTen(int number) {
        int k = 0;
        while (k < 10) {
            if (Math.pow(10.0, k) > (double)number) {
                return k - 1;
            }
            ++k;
        }
        return 0;
    }

    public static final String repeatChar(char c, int count) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < count) {
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }

    public static final String getRandom(int length) {
        double tenPow = Math.pow(10.0, length);
        double tenPowMinus = Math.pow(10.0, length - 1);
        double d = tenPow * generator.nextDouble();
        if (d < tenPowMinus) {
            d += tenPowMinus;
        }
        return "" + Math.round(d);
    }

    public static String getRandomString(int i) {
        char[] ac = new char[]{'a', 'b', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '6', '7', '8', '9'};
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            stringbuffer.append(ac[Math.abs(generator.nextInt()) % ac.length]);
            ++j;
        }
        return stringbuffer.toString();
    }

    public static int getRandomNumber() {
        return generator.nextInt();
    }

    public static int getRandomNumber(int min, int max) {
        return min + generator.nextInt(max + 1);
    }

    public static String replaceSubstring(String source, String from, String to) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        int j = 0;
        while ((j = source.indexOf(from, i)) >= 0) {
            result.append(source.substring(i, j));
            result.append(to);
            i = j + from.length();
        }
        result.append(source.substring(i));
        return result.toString();
    }

    public static void dumpDoc(DJCacheDocument djDoc) {
        System.out.println(djDoc.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void printNavigator(ViewNavigator nav) {
        ViewEntry entry = null;
        ViewEntry nextEntry = null;
        try {
            try {
                entry = nav.getFirst();
                while (entry != null) {
                    if (entry.isDocument()) {
                        System.out.println("\tDokument: " + entry.getDocument().getItemValueString("F_titel"));
                    }
                    if (entry.isCategory()) {
                        System.out.println("Kategorie: " + entry.getColumnValues().elementAt(0));
                    }
                    if (entry.isTotal()) {
                        System.out.println("Total: " + entry.getColumnValues().elementAt(3));
                    }
                    if (entry.isConflict()) {
                        System.out.println("\t\tSpeicherkonflikt: " + entry.getDocument().getItemValueString("F_titel"));
                    }
                    nextEntry = nav.getNext();
                    GC.recycle(entry);
                    entry = nextEntry;
                }
            }
            catch (NotesException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            GC.recycle(entry);
            GC.recycle(nextEntry);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        GC.recycle(entry);
        GC.recycle(nextEntry);
    }

    private DemoTools() {
    }
}

