/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_06;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import lotus.domino.Base;
import lotus.domino.ColorObject;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.RichTextNavigator;
import lotus.domino.RichTextRange;
import lotus.domino.RichTextTable;
import lotus.domino.Session;

public class ExcelToRichTextConverter {
    private String fileName;
    private RichTextItem richText;
    private String encoding = null;
    private Session session = null;
    private ColorObject color = null;
    private ColorObject altColor = null;

    public ExcelToRichTextConverter(RichTextItem rti, String useFileName) throws NotesException {
        this.fileName = useFileName;
        this.richText = rti;
        this.session = rti.getParent().getParentDatabase().getParent();
        this.color = this.session.createColorObject();
        this.color.setNotesColor(14);
        this.altColor = this.session.createColorObject();
        this.altColor.setNotesColor(15);
    }

    public void runImport() throws BiffException, IOException, NotesException {
        Workbook book = Workbook.getWorkbook((File)new File(this.fileName));
        Sheet xlsSheet = book.getSheet(0);
        this.richText.appendTable(xlsSheet.getRows(), xlsSheet.getColumns());
        RichTextTable rtt = this.getTable(this.getTableCount());
        this.setColors(rtt, true);
        RichTextNavigator rtnav = this.richText.createNavigator();
        int allCellCount = this.getCellCount(rtnav);
        if (allCellCount <= 0) {
            return;
        }
        rtnav.findNthElement(7, allCellCount - rtt.getRowCount() * rtt.getColumnCount() + 1);
        int i = 0;
        while (i < rtt.getRowCount()) {
            Cell[] row = xlsSheet.getRow(i);
            int j = 0;
            while (j < rtt.getColumnCount()) {
                this.richText.beginInsert((Base)rtnav);
                if (j < row.length) {
                    this.richText.appendText(row[j].getContents());
                } else {
                    this.richText.appendText("");
                }
                this.richText.endInsert();
                rtnav.findNextElement();
                ++j;
            }
            ++i;
        }
        book.close();
    }

    public boolean runExport(int noOfTableToExport) {
        try {
            RichTextTable rtt = this.getTable(noOfTableToExport);
            int colCount = rtt.getColumnCount();
            int rowCount = rtt.getRowCount();
            WorkbookSettings wbSet = new WorkbookSettings();
            wbSet.setLocale(new Locale("de", "DE"));
            WritableWorkbook book = Workbook.createWorkbook((File)new File(this.fileName), (WorkbookSettings)wbSet);
            WritableSheet xlsSheet = book.createSheet("NotesRichText", 0);
            RichTextRange tableAsRange = this.richText.createRange();
            tableAsRange.setBegin((Base)rtt);
            tableAsRange.setEnd((Base)rtt);
            RichTextNavigator tableCellNavigator = tableAsRange.getNavigator();
            RichTextRange cellContent = this.richText.createRange();
            tableCellNavigator.findFirstElement(7);
            int rows = 0;
            while (rows < rowCount) {
                int cols = 0;
                while (cols < colCount) {
                    cellContent.setBegin((Base)tableCellNavigator);
                    cellContent.setEnd((Base)tableCellNavigator);
                    String content = cellContent.getTextRun();
                    xlsSheet.addCell((WritableCell)new Label(cols, rows, content));
                    tableCellNavigator.findNextElement();
                    ++cols;
                }
                ++rows;
            }
            xlsSheet.addCell((WritableCell)new Label(0, rowCount + 2, "Dieses Excel Sheet wurde aus dem Domino Dokument \"" + this.richText.getParent().getItemValueString("F_titel") + "\" mit Universal ID " + this.richText.getParent().getUniversalID() + " erzeugt."));
            book.write();
            book.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private int getCellCount(RichTextNavigator nav) throws NotesException {
        int result = -1;
        if (!nav.findFirstElement(7)) {
            return 0;
        }
        result = 1;
        while (nav.findNextElement()) {
            ++result;
        }
        return result;
    }

    private void setColors(RichTextTable rtt, boolean alternateColumns) throws NotesException {
        rtt.setColor(this.color);
        rtt.setAlternateColor(this.altColor);
        if (alternateColumns) {
            rtt.setStyle(4);
        } else {
            rtt.setStyle(5);
        }
    }

    public RichTextTable getTable(int noOfTable) throws NotesException {
        RichTextNavigator rtn = this.richText.createNavigator();
        boolean ok = rtn.findFirstElement(1);
        if (!ok) {
            return null;
        }
        int i = 1;
        while (i < noOfTable) {
            rtn.findNextElement();
            ++i;
        }
        return (RichTextTable)rtn.getElement();
    }

    public int getTableCount() throws NotesException {
        RichTextNavigator rtn = this.richText.createNavigator();
        boolean ok = rtn.findFirstElement(1);
        if (!ok) {
            return 0;
        }
        int result = 1;
        while (ok) {
            ok = rtn.findNextElement();
            if (!ok) continue;
            ++result;
        }
        return result;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }
}

