/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_06;

import djbuch.kapitel_06.CustomClass;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public class GetItemReturnValues
extends NotesThread {
    private static final String PASSWORD = "geheim";
    private static final String HOST = "www.djbuch.de";
    private static final String USER = "Thomas Ekert/DJBUCH";
    private static final PrintStream out = GetItemReturnValues.fileOut();
    private static final String TYPE_NAME = "FreiGewaehlterTypName";
    private static final String[] types = new String[]{"Integer", "Double", "String", "Date", "Custom", "CustomBytes"};
    private static final String LINE = "\n************************************************************";

    public static void main(String[] args) {
        GetItemReturnValues girv = new GetItemReturnValues();
        girv.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runNotes() {
        Session session = null;
        Database db = null;
        Document doc = null;
        try {
            try {
                session = NotesFactory.createSession((String)HOST, (String)USER, (String)PASSWORD);
                db = session.getDatabase(null, "djbuch/djbuch.nsf");
                doc = db.createDocument();
                out.println("\n************************************************************\nVersuch 1 - Anzeige nicht vorhandener Items\n************************************************************\n");
                GetItemReturnValues.showBehaviorGetItem(doc, "gibtsNicht");
                out.println("\n************************************************************\nVersuch 2 - Anzeige unterschiedlicher Datentypen\n************************************************************");
                String itemName = "itemInhalt_Ist_";
                GetItemReturnValues.insertItems(session, doc, itemName);
                int i = 0;
                while (true) {
                    if (i >= types.length) break;
                    out.println("\nZeige Item <<" + itemName + types[i] + ">>");
                    GetItemReturnValues.showBehaviorGetItem(doc, String.valueOf(itemName) + types[i]);
                    ++i;
                }
                out.println("\n************************************************************\nVersuch 3 - Anzeige von Vectoren unterschiedlicher Datentypen\n************************************************************");
                itemName = "itemInhalt_Ist_Vector_";
                GetItemReturnValues.insertItemVector(session, doc, itemName);
                i = 0;
                while (true) {
                    if (i >= types.length) {
                        out.println("\n************************************************************\nDemo 4 - Mehrere Items gleichen Namens im Dokument\n************************************************************");
                        doc.recycle();
                        doc = null;
                        doc = db.createDocument();
                        itemName = "itemName";
                        doc.replaceItemValue(itemName, (Object)"Wert 1");
                        doc.appendItemValue(itemName, (Object)"Wert 2");
                        out.println("Zwei Items, daher nur ein Wert im Vector: " + doc.getItemValue(itemName));
                        Item item = doc.getFirstItem(itemName);
                        item.remove();
                        out.println("Nach dem Remove des ersten Items: Nun das zweite Item: " + doc.getItemValue(itemName));
                    }
                    out.println("\nZeige Item <<" + itemName + types[i] + ">>");
                    GetItemReturnValues.showBehaviorGetItem(doc, String.valueOf(itemName) + types[i]);
                    ++i;
                }
            }
            catch (NotesException e) {
                e.printStackTrace(System.err);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (doc != null) {
                    doc.recycle();
                }
                if (db != null) {
                    db.recycle();
                }
                if (session == null) throw throwable;
                session.recycle();
                throw throwable;
            }
            catch (NotesException e) {
                System.err.println("Fataler Fehler.");
            }
            throw throwable;
        }
        {
            Object var6_11 = null;
        }
        try {}
        catch (NotesException e) {
            System.err.println("Fataler Fehler.");
            return;
        }
        if (doc != null) {
            doc.recycle();
        }
        if (db != null) {
            db.recycle();
        }
        if (session == null) return;
        session.recycle();
    }

    private static void showBehaviorGetItem(Document doc, String name) throws NotesException {
        out.println("hasItem(\"" + name + "\"):\t\t\t\t" + doc.hasItem(name));
        try {
            out.print("getItemValueInteger(\"" + name + "\"):\t\t");
            out.println(doc.getItemValueInteger(name));
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            out.print("getItemValueDouble(\"" + name + "\"):\t\t");
            out.println(doc.getItemValueDouble(name));
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            out.print("getItemValueString(\"" + name + "\"):\t\t");
            out.println(doc.getItemValueString(name));
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            out.print("getItemValue(\"" + name + "\"):\t\t\t");
            out.println(doc.getItemValue(name));
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            out.print("getItemValueDateTimeArray(\"" + name + "\"):\t");
            out.println(doc.getItemValueDateTimeArray(name) + " (" + doc.getItemValueDateTimeArray(name).getClass().getName() + ")");
        }
        catch (NotesException e) {
            out.println("Kein DateTimeItem - " + e.toString() + " (" + e.id + ")");
        }
        try {
            out.print("getItemValueCustomData(\"" + name + "\"):\t\t");
            out.println(doc.getItemValueCustomData(name, TYPE_NAME).toString());
        }
        catch (NullPointerException e) {
            out.println("Fehlendes Custom Item - " + e.toString());
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            out.print("getItemValueCustomDataBytes(\"" + name + "\"):\t");
            out.println(GetItemReturnValues.byteToString(doc.getItemValueCustomDataBytes(name, TYPE_NAME)));
        }
        catch (NullPointerException e) {
            out.println("Fehlendes Custom Item Bytes - " + e.toString());
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
        try {
            Item item = doc.getFirstItem(name);
            out.print("getFirstItem (\"" + name + "\").getText():\t");
            try {
                out.print(item.getText());
            }
            catch (NotesException e) {
                out.print(" NotesException bei getFirstItem oder getText :" + e.getMessage());
            }
            out.println(" (Size = " + item.getValueLength() + ")");
        }
        catch (Exception e) {
            out.println("Exception " + e.toString());
        }
    }

    private static String byteToString(byte[] bArr) {
        if (bArr == null || bArr.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < bArr.length) {
            buf.append((char)bArr[i]);
            ++i;
        }
        return buf.toString();
    }

    private static void insertItems(Session session, Document doc, String name) throws NotesException, IOException {
        doc.replaceItemValue(String.valueOf(name) + types[0], (Object)new Integer(1));
        doc.replaceItemValue(String.valueOf(name) + types[1], (Object)new Double(1.7));
        doc.replaceItemValue(String.valueOf(name) + types[2], (Object)"mein String");
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        doc.replaceItemValue(String.valueOf(name) + types[3], (Object)dt);
        CustomClass custom = new CustomClass("Vorname Nachname", Calendar.getInstance().getTime());
        doc.replaceItemValueCustomData(String.valueOf(name) + types[4], TYPE_NAME, (Object)custom);
        doc.replaceItemValueCustomDataBytes(String.valueOf(name) + types[5], TYPE_NAME, custom.toString().getBytes());
    }

    private static void insertItemVector(Session session, Document doc, String name) throws NotesException, IOException {
        Vector<Object> v = new Vector<Object>();
        v.add(new Integer(3));
        v.add(new Integer(4));
        doc.replaceItemValue(String.valueOf(name) + types[0], v);
        v = new Vector();
        v.add(new Double(2.2));
        v.add(new Double(2.3));
        doc.replaceItemValue(String.valueOf(name) + types[1], v);
        v = new Vector();
        v.add("Wert a");
        v.add("Wert b");
        doc.replaceItemValue(String.valueOf(name) + types[2], v);
        Item item = doc.getFirstItem(String.valueOf(name) + types[2]);
        item.appendToTextList("Wert c via append");
        v = new Vector();
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        v.add(dt);
        dt = session.createDateTime("Today");
        v.add(dt);
        dt = session.createDateTime("17.07.2007");
        v.add(dt);
        doc.replaceItemValue(String.valueOf(name) + types[3], v);
        v = new Vector();
        CustomClass custom = new CustomClass("Vorname1 Nachname1", Calendar.getInstance().getTime());
        v.add(custom);
        custom = new CustomClass("Vorname2 Nachname2", Calendar.getInstance().getTime());
        doc.replaceItemValueCustomData(String.valueOf(name) + types[4], TYPE_NAME, v);
    }

    private static final PrintStream fileOut() {
        PrintStream result = null;
        String basePath = String.valueOf(System.getProperty("user.dir")) + "/src/djbuch/kapitel_06/";
        File file = new File(String.valueOf(basePath) + "debug");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(String.valueOf(basePath) + "debug/output.txt", true);
            result = new PrintStream(fileOut);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = System.out;
        }
        return result;
    }
}

