/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_07;

import djbuch.kapitel_06.DemoTools;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.PropertyConfigurator;
import org.shiftone.cache.Cache;
import org.shiftone.cache.CacheConfiguration;
import org.shiftone.cache.CacheFactory;
import org.shiftone.cache.ConfigurationException;

public class DJCache {
    private Cache cache = null;
    private static final DJCache singleton = new DJCache();
    private static final long TIMEOUT_IN_MILLIS = 60000L;
    private static final int MAX_OBJECTS_IN_CACHE = 500;
    private static final String NAME_DES_CACHE = "DJCache";
    private static final String BASENAME = "cache.properties";
    private static final String AUTO_CONFIG = "title               = ShiftOne Object Cache\nversion             = 2.0b\n\n# ------ [ Cache Configurations ] ----------------------------------------\n\n# Default cache configurations\ncache.factory                                       = lru\ncache.timeout                                       = 10000\ncache.maxsize                                       = 1000\n\n# Exception cache configurations\ncache.timeout.net.sf                                = 9999\ncache.maxsize.org.shiftone                          = 999\n\n# ------ [ Factory Configurations ] --------------------------------------\n\n# LRU (least recently used)\nfactory.lru                         = org.shiftone.cache.policy.lru.LruCacheFactory\n\n# statLRU (least recently used with statistical output)\nfactory.statLru                     = org.shiftone.cache.decorator.stat.StatCacheFactory\nfactory.statLru.delegate            = lru\n\n# SyncLRU (synchronized least recently used with statistical output)\nfactory.syncLru                     = org.shiftone.cache.decorator.sync.SyncCacheFactory\nfactory.syncLru.delegate            = statLru\n";

    private DJCache() {
        try {
            CacheConfiguration config = new CacheConfiguration(this.makeConfig());
            CacheFactory factory = config.getCacheFactory("syncLru");
            this.cache = factory.newInstance(NAME_DES_CACHE, 60000L, 500);
        }
        catch (ConfigurationException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final Cache getCache() {
        return DJCache.singleton.cache;
    }

    protected String makeConfig() throws IOException {
        String filename = BASENAME;
        String basePath = String.valueOf(DemoTools.replaceSubstring(System.getProperty("user.dir"), "\\", "/")) + "/java/";
        String string = basePath = basePath == null ? "" : basePath;
        if (DemoTools.exists(String.valueOf(basePath) + filename)) {
            System.out.println("Loading DJCache Config from file: " + basePath + filename);
            PropertyConfigurator.configure((String)(String.valueOf(basePath) + filename));
        } else {
            System.out.println("Generating NEW DJCache Default Config in file: " + basePath + filename);
            DemoTools.makeDir(basePath);
            FileWriter fw = new FileWriter(String.valueOf(basePath) + filename);
            fw.write(AUTO_CONFIG);
            fw.flush();
            fw.close();
            Object var3_3 = null;
        }
        return String.valueOf(basePath) + filename;
    }
}

