/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_07;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.Session;

public class DJCacheDocument {
    private static final int DJCACHEDOMINOEXCEPTIONID = 999;
    private static final boolean SIMULATE_R7 = true;
    private static final boolean IS_IIOP = false;
    private Map elements = Collections.synchronizedMap(new HashMap());
    private FieldNames fn = new FieldNames();
    private String universalID = null;
    private String parentDocumentUNID = null;
    private String parentDatabaseFilePath = null;
    private String parentDatabaseFileName = null;
    private String parentDatabaseReplicaID = null;
    static /* synthetic */ Class class$0;

    public DJCacheDocument(Document doc) throws NotesException {
        if (doc != null) {
            this.init(doc);
        }
    }

    public void appendItemValue(String fieldName, Object value) {
        if (!DJCacheDocument.ok(fieldName)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        Vector<Object> v = new Vector<Object>();
        boolean isDateTime = false;
        if (value instanceof Vector) {
            v = (Vector<Object>)value;
            if (DJCacheDocument.isInteger(v)) {
                v = DJCacheDocument.toDouble(v);
            } else if (DJCacheDocument.isDateTime(v)) {
                isDateTime = true;
                v = DJCacheDocument.toJavaDate(v);
            }
        } else if (value instanceof Integer) {
            v.addElement(new Double(((Integer)value).doubleValue()));
        } else if (value instanceof DateTime) {
            isDateTime = true;
            try {
                v.addElement(((DateTime)value).toJavaDate());
            }
            catch (NotesException e) {
                v = new Vector<Object>();
                v.addElement("");
            }
        } else {
            v.addElement(value);
        }
        this.elements.put(this.fn.addName(fieldName), v);
        if (isDateTime) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("lotus.domino.DateTime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fn.setType(fieldName, clazz.getName());
        }
    }

    public void appendItemValue(String fieldName) {
        this.appendItemValue(fieldName, "");
    }

    public void appendItemValue(String fieldName, int value) {
        this.appendItemValue(fieldName, new Double(value));
    }

    public void appendItemValue(String fieldName, double value) {
        this.appendItemValue(fieldName, new Double(value));
    }

    public Vector getItemValue(String fieldName) {
        if (!this.hasItem(fieldName)) {
            return new Vector();
        }
        Object result = this.elements.get(this.fn.makeName(fieldName));
        if (result != null) {
            return (Vector)result;
        }
        return new Vector();
    }

    public String getItemValueString(String fieldName) {
        if (!this.hasItem(fieldName)) {
            return "";
        }
        Vector retVal = this.getItemValue(fieldName);
        try {
            return (String)retVal.firstElement();
        }
        catch (Exception otherException) {
            return "";
        }
    }

    public int getItemValueInteger(String fieldName) {
        if (!this.hasItem(fieldName)) {
            return 0;
        }
        double val = this.getItemValueDouble(fieldName);
        int mult = val < 0.0 ? -1 : 1;
        return mult * Math.round(new Double(Math.abs(val)).floatValue());
    }

    public double getItemValueDouble(String fieldName) {
        if (!this.hasItem(fieldName)) {
            return 0.0;
        }
        Vector retVal = this.getItemValue(fieldName);
        try {
            return (Double)retVal.firstElement();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public Vector getItemValueDateTimeArray(String fieldName, Session session) throws NotesException {
        String type = this.fn.getType(fieldName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("lotus.domino.DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.getName().equals(type)) {
            Vector source = this.getItemValue(fieldName);
            Vector<DateTime> result = new Vector<DateTime>();
            int i = 0;
            while (i < source.size()) {
                result.add(session.createDateTime((Date)source.elementAt(i)));
                ++i;
            }
            return result;
        }
        throw new NotesException(4637, "Item value is not a date type");
    }

    public String getType(String fieldName) {
        return this.fn.getType(fieldName);
    }

    public Vector getAllItemNames() {
        return this.fn.getAllNames();
    }

    public String getParentDocumentUNID() {
        return this.parentDocumentUNID;
    }

    public String getUniversalID() {
        return this.universalID;
    }

    public void replaceItemValue(String fieldName, Object value) {
        this.removeItem(fieldName);
        this.appendItemValue(fieldName, value);
    }

    public void removeItem(String fieldName) {
        if (!this.fn.hasName(fieldName)) {
            return;
        }
        Vector v = this.fn.getNames(fieldName);
        int i = 0;
        while (i < v.size()) {
            this.elements.remove((String)v.elementAt(i));
            ++i;
        }
        this.fn.removeName(fieldName);
    }

    public boolean hasItem(String fieldName) {
        return this.fn.hasName(fieldName);
    }

    public void recycle() {
    }

    public String toString() {
        String tmp = this.elements.toString().replace(',', '\n');
        return " " + tmp.substring(1, tmp.length() - 1);
    }

    public String getParentDatabaseFileName() {
        return this.parentDatabaseFileName;
    }

    public String getParentDatabaseFilePath() {
        return this.parentDatabaseFilePath;
    }

    public Database getParentDatabase(Session session) throws NotesException {
        if (this.parentDatabaseReplicaID == null || this.parentDatabaseReplicaID.equals("")) {
            throw new NotesException(999, "Das DJCacheDocument hat keine Parent Datenbank.");
        }
        return session.getDbDirectory("").openDatabaseByReplicaID(this.parentDatabaseReplicaID);
    }

    public Document getDocument(Session session) throws NotesException {
        if (this.universalID == null) {
            throw new NotesException(999, "Das DJCacheDocument hat keine Universal ID.");
        }
        return this.getParentDatabase(session).getDocumentByUNID(this.universalID);
    }

    /*
     * Unable to fully structure code
     */
    public Document createDocument(Database db) throws NotesException {
        result = db.createDocument();
        v = this.getAllItemNames();
        i = 0;
        s = v.size();
        while (i < s) {
            name = (String)v.elementAt(i);
            if (this.getType(name) == null) ** GOTO lbl-1000
            v0 = this.getType(name);
            v1 = DJCacheDocument.class$0;
            if (v1 == null) {
                try {
                    v1 = Class.forName("lotus.domino.DateTime");
                }
                catch (ClassNotFoundException v2) {
                    throw new NoClassDefFoundError(v2.getMessage());
                }
            }
            if (v0.equals(v1.getName())) {
                result.replaceItemValue(name, (Object)this.getItemValueDateTimeArray(name, db.getParent()));
            } else lbl-1000:
            // 2 sources

            {
                result.replaceItemValue(name, (Object)this.getItemValue(name));
            }
            ++i;
        }
        return result;
    }

    private static boolean ok(String fieldName) {
        return fieldName != null && fieldName.length() > 0;
    }

    private void init(Document doc) throws NotesException {
        this.universalID = doc.getUniversalID();
        this.parentDocumentUNID = doc.getParentDocumentUNID();
        this.parentDatabaseFilePath = doc.getParentDatabase().getFilePath();
        this.parentDatabaseFileName = doc.getParentDatabase().getFileName();
        this.parentDatabaseReplicaID = doc.getParentDatabase().getReplicaID();
        Vector v = doc.getItems();
        Item item = null;
        int i = v.size() - 1;
        while (i >= 0) {
            item = (Item)v.elementAt(i);
            if (item != null && (item.getType() == 1280 || item.getType() == 1076 || item.getType() == 1024 || item.getType() == 1074 || item.getType() == 768)) {
                this.appendItemValue(item.getName(), item.getValues());
            }
            --i;
        }
    }

    protected static Vector toJavaDate(Vector source) {
        if (source == null) {
            return null;
        }
        Vector<Date> newVector = new Vector<Date>();
        int i = 0;
        while (i < source.size()) {
            try {
                newVector.add(((DateTime)source.elementAt(i)).toJavaDate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return newVector;
    }

    protected static Vector toDouble(Vector source) {
        if (source == null) {
            return null;
        }
        Vector<Double> newVector = new Vector<Double>();
        int i = 0;
        while (i < source.size()) {
            try {
                newVector.add(new Double(((Integer)source.elementAt(i)).doubleValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return newVector;
    }

    protected static boolean isDateTime(Vector source) {
        if (source == null) {
            return false;
        }
        int i = 0;
        while (i < source.size()) {
            if (source.elementAt(i) instanceof DateTime) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isInteger(Vector source) {
        if (source == null) {
            return false;
        }
        int i = 0;
        while (i < source.size()) {
            if (source.elementAt(i) instanceof Integer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected class FieldNames {
        protected static final char SIGN = '!';
        protected Set names = Collections.synchronizedSet(new HashSet());
        protected Map types = Collections.synchronizedMap(new HashMap());

        protected FieldNames() {
        }

        protected boolean hasName(String fieldName) {
            if (!DJCacheDocument.ok(fieldName)) {
                return false;
            }
            return this.names.contains(this.makeName(fieldName));
        }

        protected boolean hasName(String fieldName, int i) {
            if (!DJCacheDocument.ok(fieldName)) {
                return false;
            }
            return this.names.contains(this.makeName(fieldName, i));
        }

        protected String makeName(String fieldName) {
            return fieldName.toLowerCase();
        }

        protected String makeName(String fieldName, int i) {
            if (i == 0) {
                return fieldName.toLowerCase();
            }
            return fieldName.toLowerCase() + '!' + i;
        }

        protected Vector getNames(String fieldName) {
            if (!this.hasName(fieldName)) {
                return null;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (this.hasName(fieldName, i)) {
                v.add(this.makeName(fieldName, i));
                ++i;
            }
            return v;
        }

        protected int getNameCount(String fieldName) {
            if (!this.hasName(fieldName)) {
                return 0;
            }
            return this.getNames(fieldName).size();
        }

        protected String addName(String fieldName) {
            if (!DJCacheDocument.ok(fieldName)) {
                return null;
            }
            String name = null;
            name = !this.hasName(fieldName) ? this.makeName(fieldName) : this.makeName(fieldName, this.getNameCount(fieldName));
            this.names.add(name);
            return name;
        }

        protected void removeName(String fieldName) {
            if (!this.hasName(fieldName)) {
                return;
            }
            Vector v = this.getNames(fieldName);
            int i = 0;
            while (i < v.size()) {
                this.names.remove(this.makeName(fieldName, i));
                ++i;
            }
        }

        protected void setType(String fieldName, String value) {
            this.setType(fieldName, value, 0);
        }

        protected void setType(String fieldName, String value, int i) {
            if (!DJCacheDocument.ok(fieldName)) {
                return;
            }
            this.types.put(this.makeName(fieldName, i), value);
        }

        protected String getType(String fieldName) {
            return this.getType(fieldName, 0);
        }

        protected String getType(String fieldName, int i) {
            if (!DJCacheDocument.ok(fieldName)) {
                return null;
            }
            return (String)this.types.get(this.makeName(fieldName, i));
        }

        protected void removeType(String fieldName) {
            this.removeType(fieldName, 0);
        }

        protected void removeType(String fieldName, int i) {
            if (!DJCacheDocument.ok(fieldName)) {
                return;
            }
            this.types.remove(this.makeName(fieldName, i));
        }

        protected Vector getAllNames() {
            Vector<String> v = new Vector<String>();
            Iterator e = this.names.iterator();
            while (e.hasNext()) {
                String part = (String)e.next();
                int index = part.lastIndexOf(33);
                String string = part = index != -1 ? part.substring(0, index) : part;
                if (v.contains(part)) continue;
                v.add(part);
            }
            return v;
        }
    }
}

