/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_07;

import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import djbuch.kapitel_07.DJCacheDocument;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

public class DJCacheDocumentTest
extends TestCase {
    private Session session = null;
    private Database db = null;
    private Document doc = null;
    private static final String PASSWORD = "1geheim";
    private static final String HOST = null;
    private static final String USER = null;
    private static final String[] types = new String[]{"Integer", "Double", "String", "DateTime"};
    private static final int STRESS_COUNT = 1000;

    public void testDJCacheDocument() {
        try {
            int m;
            int m2;
            this.doc.save(true, false);
            DJCacheDocument cacheDoc = new DJCacheDocument(this.doc);
            this.allTypes("<diesesItemGibtEsNicht>", this.doc, cacheDoc);
            cacheDoc.appendItemValue("drei", 3);
            DJCacheDocumentTest.insertItems(this.session, this.doc, "einfachesItem");
            DJCacheDocumentTest.insertItems(this.session, cacheDoc, "einfachesItem");
            this.allTypes("einfachesItem", this.doc, cacheDoc);
            DJCacheDocumentTest.insertItemVector(this.session, this.doc, "vectorItem");
            DJCacheDocumentTest.insertItemVector(this.session, cacheDoc, "vectorItem");
            this.allTypes("vectorItem", this.doc, cacheDoc);
            long L = System.currentTimeMillis();
            int i = 0;
            while (i < 1000) {
                cacheDoc = new DJCacheDocument(this.doc);
                ++i;
            }
            System.out.println("\n1000 neue DJCacheDocument erstellen: " + (System.currentTimeMillis() - L) + "ms");
            L = System.currentTimeMillis();
            i = 0;
            while (i < 1000) {
                Document document = this.doc.copyToDatabase(this.db);
                ++i;
            }
            System.out.println("1000 neue Document erstellen: " + (System.currentTimeMillis() - L) + "ms");
            Vector v = cacheDoc.getAllItemNames();
            int count = v.size();
            L = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < 1000) {
                m2 = 0;
                while (m2 < v.size()) {
                    cacheDoc.getItemValue((String)v.elementAt(m2));
                    ++m2;
                }
                ++i2;
            }
            System.out.println("\n1000 x " + count + " DJCacheDocument.getItemValue Operationen: " + (System.currentTimeMillis() - L) + "ms");
            v = cacheDoc.getAllItemNames();
            L = System.currentTimeMillis();
            i2 = 0;
            while (i2 < 1000) {
                m2 = 0;
                while (m2 < v.size()) {
                    this.doc.getItemValue((String)v.elementAt(m2));
                    ++m2;
                }
                ++i2;
            }
            System.out.println("1000 x " + count + " Document.getIemValue Operationen: " + (System.currentTimeMillis() - L) + "ms");
            v = cacheDoc.getAllItemNames();
            Vector<String> values = new Vector<String>();
            m2 = 0;
            while (m2 < v.size()) {
                values.add(this.doc.getItemValue((String)v.elementAt(m2)).toString());
                ++m2;
            }
            L = System.currentTimeMillis();
            int i3 = 0;
            while (i3 < 1000) {
                m = 0;
                while (m < v.size()) {
                    cacheDoc.replaceItemValue((String)v.elementAt(m), (String)values.elementAt(m));
                    ++m;
                }
                ++i3;
            }
            System.out.println("\n1000 x " + count + " DJCacheDocument.replaceIemValue Operationen: " + (System.currentTimeMillis() - L) + "ms");
            L = System.currentTimeMillis();
            v = cacheDoc.getAllItemNames();
            i3 = 0;
            while (i3 < 1000) {
                m = 0;
                while (m < v.size()) {
                    this.doc.replaceItemValue((String)v.elementAt(m), (Object)((String)values.elementAt(m)));
                    ++m;
                }
                ++i3;
            }
            System.out.println("1000 x " + count + " Document.replaceIemValue Operationen: " + (System.currentTimeMillis() - L) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Exception aufgetreten", (boolean)false);
        }
        System.out.println("Teste DJCacheDocument done.");
    }

    public void testFieldNames() {
        DJCacheDocument cacheDoc = null;
        try {
            cacheDoc = new DJCacheDocument(this.doc);
            DJCacheDocument.FieldNames fn = cacheDoc.new DJCacheDocument.FieldNames();
            Assert.assertFalse((boolean)fn.hasName("nix"));
            Assert.assertFalse((boolean)fn.hasName(""));
            Assert.assertFalse((boolean)fn.hasName(null));
            DJCacheDocumentTest.allNames(fn, "Neu");
            DJCacheDocumentTest.allNames(fn, "neU");
            DJCacheDocumentTest.allNames(fn, "n e u");
            DJCacheDocumentTest.allNames(fn, "n!eu!0");
            Assert.assertEquals(null, (String)fn.addName(null));
            fn = cacheDoc.new DJCacheDocument.FieldNames();
            Assert.assertFalse((boolean)fn.hasName(null));
            fn.addName("a");
            fn.addName("a");
            fn.addName("b");
            Assert.assertTrue(("[a, b]".equals(fn.getAllNames().toString()) || "[b, a]".equals(fn.getAllNames().toString()) ? 1 : 0) != 0);
        }
        catch (NotesException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Exception aufgetreten", (boolean)false);
        }
        System.out.println("Teste FieldNames done.");
    }

    private void allTypes(String name, Document dominoDoc, DJCacheDocument cacheDoc) throws NotesException {
        System.out.println("\n\nTeste alle getItem Methoden f\u00fcr Feld " + name);
        int k = 0;
        while (k < types.length) {
            Vector dominoDT;
            String fieldname = String.valueOf(name) + types[k];
            System.out.println("\tTeste getItemValueString gegen Typ " + fieldname);
            Assert.assertEquals((String)dominoDoc.getItemValueString(fieldname), (String)cacheDoc.getItemValueString(fieldname));
            System.out.println("\tTeste getItemValueInteger gegen Typ " + fieldname);
            Assert.assertEquals((int)dominoDoc.getItemValueInteger(fieldname), (int)cacheDoc.getItemValueInteger(fieldname));
            System.out.println("\tTeste getItemValueDouble gegen Typ " + fieldname);
            Assert.assertEquals((double)dominoDoc.getItemValueDouble(fieldname), (double)cacheDoc.getItemValueDouble(fieldname), (double)1.0E-6);
            System.out.println("\tTeste getItemValue gegen Typ " + fieldname);
            if (dominoDoc.getFirstItem(fieldname) != null && dominoDoc.getFirstItem(fieldname).getType() == 1024) {
                Vector domino = DJCacheDocument.toJavaDate(dominoDoc.getItemValue(fieldname));
                Vector cache = cacheDoc.getItemValue(fieldname);
                Assert.assertEquals((int)domino.size(), (int)cache.size());
                int m = 0;
                while (m < domino.size()) {
                    Assert.assertEquals((float)0.0f, (float)((Date)domino.elementAt(m)).compareTo((Date)cache.elementAt(m)), (float)10.0f);
                    ++m;
                }
            } else {
                Assert.assertEquals((Object)dominoDoc.getItemValue(fieldname), (Object)cacheDoc.getItemValue(fieldname));
            }
            System.out.println("\tTeste hasItem");
            Assert.assertEquals((boolean)dominoDoc.hasItem(fieldname), (boolean)cacheDoc.hasItem(fieldname));
            System.out.println("\tTeste getItemValueDateTimeArray gegen Typ " + fieldname);
            try {
                Vector cacheDT = cacheDoc.getItemValueDateTimeArray(fieldname, this.session);
                dominoDT = dominoDoc.getItemValueDateTimeArray(fieldname);
                int i = 0;
                while (i < dominoDT.size()) {
                    Assert.assertEquals((int)0, (int)((DateTime)dominoDT.elementAt(i)).timeDifference((DateTime)cacheDT.elementAt(i)));
                    ++i;
                }
            }
            catch (NotesException expected) {
                try {
                    dominoDT = dominoDoc.getItemValueDateTimeArray(fieldname);
                    Assert.assertTrue((String)"Wenn das domino Doc eine exception wirft, dann auch das cacheDoc", (boolean)false);
                }
                catch (NotesException expectedFollowUP) {
                    Assert.assertTrue((boolean)true);
                }
            }
            ++k;
        }
    }

    private static void insertItems(Session session, Document doc, String name) throws NotesException {
        doc.replaceItemValue(String.valueOf(name) + types[0], (Object)new Integer(-3));
        doc.replaceItemValue(String.valueOf(name) + types[1], (Object)new Double(-1.5));
        doc.replaceItemValue(String.valueOf(name) + types[2], (Object)"mein String");
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        doc.replaceItemValue(String.valueOf(name) + types[3], (Object)dt);
    }

    private static void insertItems(Session session, DJCacheDocument doc, String name) throws NotesException {
        doc.replaceItemValue(String.valueOf(name) + types[0], new Integer(-3));
        doc.replaceItemValue(String.valueOf(name) + types[1], new Double(-1.5));
        doc.replaceItemValue(String.valueOf(name) + types[2], "mein String");
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        doc.replaceItemValue(String.valueOf(name) + types[3], dt);
    }

    private static void insertItemVector(Session session, Document doc, String name) throws NotesException {
        Vector<Object> v = new Vector<Object>();
        v.add(new Integer(3));
        v.add(new Integer(4));
        v.add(new Integer(-3));
        v.add(new Integer(-4));
        doc.replaceItemValue(String.valueOf(name) + types[0], v);
        v = new Vector();
        v.add(new Double(2.2));
        v.add(new Double(2.5));
        v.add(new Double(-2.2));
        v.add(new Double(-2.5));
        doc.replaceItemValue(String.valueOf(name) + types[1], v);
        v = new Vector();
        v.add("Wert a");
        v.add("Wert b");
        doc.replaceItemValue(String.valueOf(name) + types[2], v);
        v = new Vector();
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        v.add(dt);
        dt = session.createDateTime("Today");
        v.add(dt);
        dt = session.createDateTime("17.07.2007");
        v.add(dt);
        doc.replaceItemValue(String.valueOf(name) + types[3], v);
    }

    private static void insertItemVector(Session session, DJCacheDocument doc, String name) throws NotesException, IOException {
        Vector<Object> v = new Vector<Object>();
        v.add(new Integer(3));
        v.add(new Integer(4));
        v.add(new Integer(-3));
        v.add(new Integer(-4));
        doc.replaceItemValue(String.valueOf(name) + types[0], v);
        v = new Vector();
        v.add(new Double(2.2));
        v.add(new Double(2.5));
        v.add(new Double(-2.2));
        v.add(new Double(-2.5));
        doc.replaceItemValue(String.valueOf(name) + types[1], v);
        v = new Vector();
        v.add("Wert a");
        v.add("Wert b");
        doc.replaceItemValue(String.valueOf(name) + types[2], v);
        v = new Vector();
        DateTime dt = session.createDateTime("Yesterday 11:35:07");
        v.add(dt);
        dt = session.createDateTime("Today");
        v.add(dt);
        dt = session.createDateTime("17.07.2007");
        v.add(dt);
        doc.replaceItemValue(String.valueOf(name) + types[3], v);
    }

    private static void allNames(DJCacheDocument.FieldNames fn, String key) {
        fn.addName(key);
        Assert.assertTrue((boolean)fn.hasName(key));
        fn.removeName(key);
        Assert.assertFalse((boolean)fn.hasName(key));
        Assert.assertEquals((String)key.toLowerCase(), (String)fn.addName(key));
        Assert.assertEquals((String)(String.valueOf(key.toLowerCase()) + '!' + 1), (String)fn.addName(key.toUpperCase()));
        Assert.assertEquals((String)(String.valueOf(key.toLowerCase()) + '!' + 2), (String)fn.addName(key.toLowerCase()));
        Assert.assertTrue((boolean)fn.hasName(key.toLowerCase()));
        Assert.assertTrue((boolean)fn.hasName(key.toUpperCase()));
        Assert.assertTrue((boolean)fn.hasName(key));
        Assert.assertTrue((boolean)fn.hasName(key, 1));
        Assert.assertTrue((boolean)fn.hasName(key.toUpperCase(), 1));
        Assert.assertTrue((boolean)fn.hasName(key, 2));
        Assert.assertFalse((boolean)fn.hasName(key, 3));
        Assert.assertFalse((boolean)fn.hasName(key.toLowerCase(), 3));
        Assert.assertEquals((int)3, (int)fn.getNameCount(key));
        Vector v = fn.getNames(key);
        Assert.assertFalse((v == null ? 1 : 0) != 0);
        Assert.assertEquals((int)3, (int)v.size());
        int i = 0;
        while (i < v.size()) {
            Assert.assertEquals((String)(String.valueOf(key.toLowerCase()) + (i == 0 ? "" : "!" + i)), (String)((String)v.elementAt(i)));
            ++i;
        }
        fn.removeName(key);
        Assert.assertEquals((int)0, (int)fn.getNameCount(key));
        Assert.assertEquals(null, (Object)fn.getNames(key));
        Assert.assertFalse((boolean)fn.hasName(key, 0));
        Assert.assertFalse((boolean)fn.hasName(key, 1));
        Assert.assertFalse((boolean)fn.hasName(key, 2));
        Assert.assertFalse((boolean)fn.hasName(key.toUpperCase(), 2));
        Assert.assertFalse((boolean)fn.hasName(key, 3));
        Assert.assertFalse((boolean)fn.hasName(key));
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (HOST == null) {
            NotesThread.sinitThread();
        }
        this.session = NotesFactory.createSession((String)HOST, (String)USER, (String)PASSWORD);
        this.db = this.session.getDatabase(this.session.getServerName(), "djbuch/djbuch.nsf");
        this.doc = DemoTools.createDoc(this.db, "FO_document_k7", "JUNIT", "Testdokument", null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.doc.remove(true);
        GC.recycle(this.doc);
        GC.recycle(this.db);
        GC.recycle(this.session);
        if (HOST == null) {
            NotesThread.stermThread();
        }
    }
}

