/*
 * Decompiled with CFR 0.152.
 */
package djbuch.kapitel_07;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.EmbeddedObject;
import lotus.domino.Item;
import lotus.domino.MIMEEntity;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.View;
import lotus.domino.XSLTResultTarget;

public class DJDocument {
    private Document doc = null;
    private boolean isRecycledOrRemoved = true;
    private static final int EXCEPTION_NO = 4376;
    private static final String EXCEPTION_MSG = "Document has been removed or recycled.";

    public DJDocument(Document initialDoc) {
        this.setDoc(initialDoc);
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document initialDoc) {
        if (this.doc != null && !this.isRecycledOrRemoved) {
            try {
                this.doc.recycle();
            }
            catch (NotesException e) {
                e.printStackTrace();
            }
        }
        if (initialDoc != null) {
            this.isRecycledOrRemoved = false;
        }
        this.doc = initialDoc;
    }

    public void makeResponse(Document arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.makeResponse(arg0);
    }

    public void makeResponse(DJDocument arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.makeResponse(arg0.getDoc());
    }

    public void copyAllItems(Document arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.copyAllItems(arg0, arg1);
    }

    public void copyAllItems(DJDocument arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.copyAllItems(arg0.getDoc(), arg1);
    }

    public boolean remove(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        boolean result = this.doc.remove(arg0);
        this.isRecycledOrRemoved = true;
        return result;
    }

    public boolean removePermanently(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        boolean result = this.doc.removePermanently(arg0);
        this.isRecycledOrRemoved = true;
        return result;
    }

    public void recycle() throws NotesException {
        if (this.doc == null) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.recycle();
        this.doc = null;
        this.isRecycledOrRemoved = true;
    }

    public void recycle(Vector arg0) throws NotesException {
        if (this.doc == null) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        Vector<Object> v = new Vector<Object>();
        boolean myself = false;
        int i = 0;
        int size = arg0.size();
        while (i < size) {
            Object o = arg0.elementAt(i);
            if (o instanceof DJDocument) {
                Document thisDoc = ((DJDocument)o).getDoc();
                if (thisDoc != null) {
                    v.add(thisDoc);
                    if (thisDoc.equals(this.getDoc())) {
                        myself = true;
                    }
                }
            } else {
                v.add(o);
                if (o.equals(this.getDoc())) {
                    myself = true;
                }
            }
            ++i;
        }
        this.doc.recycle(v);
        if (myself) {
            this.doc = null;
            this.isRecycledOrRemoved = true;
        }
    }

    public Item appendItemValue(String arg0, Object arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.appendItemValue(arg0, arg1);
    }

    public Item appendItemValue(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.appendItemValue(arg0);
    }

    public Item appendItemValue(String arg0, int arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.appendItemValue(arg0, arg1);
    }

    public Item appendItemValue(String arg0, double arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.appendItemValue(arg0, arg1);
    }

    public boolean closeMIMEEntities() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.closeMIMEEntities();
    }

    public boolean closeMIMEEntities(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.closeMIMEEntities(arg0);
    }

    public boolean closeMIMEEntities(boolean arg0, String arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.closeMIMEEntities(arg0, arg1);
    }

    public boolean computeWithForm(boolean arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.computeWithForm(arg0, arg1);
    }

    public Item copyItem(Item arg0, String arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.copyItem(arg0, arg1);
    }

    public Item copyItem(Item arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.copyItem(arg0);
    }

    public Document copyToDatabase(Database arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.copyToDatabase(arg0);
    }

    public MIMEEntity createMIMEEntity() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.createMIMEEntity();
    }

    public MIMEEntity createMIMEEntity(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.createMIMEEntity(arg0);
    }

    public RichTextItem createRichTextItem(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.createRichTextItem(arg0);
    }

    public Document createReplyMessage(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.createReplyMessage(arg0);
    }

    public void encrypt() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.encrypt();
    }

    public EmbeddedObject getAttachment(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getAttachment(arg0);
    }

    public Vector getAuthors() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getAuthors();
    }

    public Vector getColumnValues() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getColumnValues();
    }

    public DateTime getCreated() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getCreated();
    }

    public Vector getEmbeddedObjects() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getEmbeddedObjects();
    }

    public Vector getEncryptionKeys() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getEncryptionKeys();
    }

    public void setEncryptionKeys(Vector arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.setEncryptionKeys(arg0);
    }

    public Item getFirstItem(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getFirstItem(arg0);
    }

    public int getFTSearchScore() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.getFTSearchScore();
    }

    public DateTime getLastAccessed() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getLastAccessed();
    }

    public DateTime getLastModified() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getLastModified();
    }

    public Vector getFolderReferences() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getFolderReferences();
    }

    public MIMEEntity getMIMEEntity() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getMIMEEntity();
    }

    public MIMEEntity getMIMEEntity(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getMIMEEntity(arg0);
    }

    public Vector getItems() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItems();
    }

    public Vector getItemValue(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValue(arg0);
    }

    public String getItemValueString(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueString(arg0);
    }

    public int getItemValueInteger(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueInteger(arg0);
    }

    public double getItemValueDouble(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueDouble(arg0);
    }

    public Object getItemValueCustomData(String arg0, String arg1) throws IOException, ClassNotFoundException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueCustomData(arg0, arg1);
    }

    public Object getItemValueCustomData(String arg0) throws IOException, ClassNotFoundException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueCustomData(arg0);
    }

    public byte[] getItemValueCustomDataBytes(String arg0, String arg1) throws IOException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueCustomDataBytes(arg0, arg1);
    }

    public Vector getItemValueDateTimeArray(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getItemValueDateTimeArray(arg0);
    }

    public String getKey() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getKey();
    }

    public String getNameOfProfile() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getNameOfProfile();
    }

    public String getNoteID() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getNoteID();
    }

    public Database getParentDatabase() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getParentDatabase();
    }

    public String getParentDocumentUNID() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getParentDocumentUNID();
    }

    public View getParentView() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getParentView();
    }

    public DocumentCollection getResponses() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getResponses();
    }

    public String getSigner() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getSigner();
    }

    public int getSize() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getSize();
    }

    public String getUniversalID() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getUniversalID();
    }

    public void setUniversalID(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.setUniversalID(arg0);
    }

    public String getVerifier() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getVerifier();
    }

    public boolean hasEmbedded() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.hasEmbedded();
    }

    public boolean hasItem(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.hasItem(arg0);
    }

    public boolean isEncrypted() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isEncrypted();
    }

    public boolean isEncryptOnSend() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isEncryptOnSend();
    }

    public void setEncryptOnSend(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.setEncryptOnSend(arg0);
    }

    public boolean isNewNote() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isNewNote();
    }

    public boolean isProfile() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isProfile();
    }

    public boolean isResponse() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isResponse();
    }

    public boolean isSigned() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isSigned();
    }

    public boolean isValid() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isValid();
    }

    public boolean isSaveMessageOnSend() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isSaveMessageOnSend();
    }

    public void setSaveMessageOnSend(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.setSaveMessageOnSend(arg0);
    }

    public boolean isSentByAgent() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isSentByAgent();
    }

    public boolean isSignOnSend() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isSignOnSend();
    }

    public void setSignOnSend(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.setSignOnSend(arg0);
    }

    public boolean isDeleted() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.isDeleted();
    }

    public void putInFolder(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.putInFolder(arg0);
    }

    public void putInFolder(String arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.putInFolder(arg0, arg1);
    }

    public void removeFromFolder(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.removeFromFolder(arg0);
    }

    public void removeItem(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.removeItem(arg0);
    }

    public boolean renderToRTItem(RichTextItem arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.renderToRTItem(arg0);
    }

    public Item replaceItemValue(String arg0, Object arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.replaceItemValue(arg0, arg1);
    }

    public Item replaceItemValueCustomData(String arg0, String arg1, Object arg2) throws IOException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.replaceItemValueCustomData(arg0, arg1, arg2);
    }

    public Item replaceItemValueCustomData(String arg0, Object arg1) throws IOException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.replaceItemValueCustomData(arg0, arg1);
    }

    public Item replaceItemValueCustomDataBytes(String arg0, String arg1, byte[] arg2) throws IOException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.replaceItemValueCustomDataBytes(arg0, arg1, arg2);
    }

    public boolean save(boolean arg0, boolean arg1, boolean arg2) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.save(arg0, arg1, arg2);
    }

    public boolean save(boolean arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.save(arg0, arg1);
    }

    public boolean save(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.save(arg0);
    }

    public boolean save() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.save();
    }

    public void send(boolean arg0, Vector arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send(arg0, arg1);
    }

    public void send(Vector arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send(arg0);
    }

    public void send(boolean arg0, String arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send(arg0, arg1);
    }

    public void send(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send(arg0);
    }

    public void send(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send(arg0);
    }

    public void send() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.send();
    }

    public void sign() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.sign();
    }

    public String getURL() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getURL();
    }

    public String getNotesURL() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getNotesURL();
    }

    public String getHttpURL() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getHttpURL();
    }

    public String generateXML() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.generateXML();
    }

    public void generateXML(Writer arg0) throws NotesException, IOException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.generateXML(arg0);
    }

    public void generateXML(Object arg0, XSLTResultTarget arg1) throws IOException, NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.generateXML(arg0, arg1);
    }

    public Vector getReceivedItemText() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getReceivedItemText();
    }

    public Vector getLockHolders() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.getLockHolders();
    }

    public boolean lock() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock();
    }

    public boolean lock(boolean arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock(arg0);
    }

    public boolean lock(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock(arg0);
    }

    public boolean lock(String arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock(arg0, arg1);
    }

    public boolean lock(Vector arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock(arg0);
    }

    public boolean lock(Vector arg0, boolean arg1) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lock(arg0, arg1);
    }

    public boolean lockProvisional() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lockProvisional();
    }

    public boolean lockProvisional(String arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lockProvisional(arg0);
    }

    public boolean lockProvisional(Vector arg0) throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        return this.doc.lockProvisional(arg0);
    }

    public void unlock() throws NotesException {
        if (this.doc == null || this.isRecycledOrRemoved) {
            throw new NotesException(4376, EXCEPTION_MSG);
        }
        this.doc.unlock();
    }
}

