/*
 * Decompiled with CFR 0.152.
 */
package djbuch.rssnews;

import djbuch.kapitel_06.DemoTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lotus.domino.AgentContext;
import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.NotesException;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

public class RSSNewsR7 {
    private Session session = null;
    private Database db = null;
    private Document doc = null;
    private String code = null;
    private static final String ITEM_BODY = "Body";
    private static final String BEGIN = "<html>\n<head>\n<title>DEMO RSS - Ticker</title>\n</head>\n<body>\n";
    private static final String END = "\n</body>\n</html>";
    private static final String xsl = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\"><xsl:for-each select=\"query\"><xsl:for-each select=\"item\"><xsl:if test=\"position()=1\"><table border=\"0\"><tbody><xsl:for-each select=\"../item\"><tr height=\"8px\"><td width=\"471\"><xsl:for-each select=\"title\"><a text-decoration=\"underline\" color=\"blue\"><xsl:attribute name=\"href\"><xsl:value-of select=\"../link\" /></xsl:attribute><span style=\"font-family:Verdana; font-size:10px; font-style:normal; text-decoration:none\"><xsl:apply-templates/></span></a></xsl:for-each></td></tr></xsl:for-each></tbody></table></xsl:if></xsl:for-each></xsl:for-each></xsl:template><xsl:template match=\"item\"><xsl:apply-templates/></xsl:template></xsl:stylesheet>";

    public RSSNewsR7(AgentContext ac) throws NotesException {
        this.db = ac.getCurrentDatabase();
        this.doc = ac.getDocumentContext();
        this.session = this.db.getParent();
    }

    public void process() throws IOException {
        String base = "";
        String NL = "\n";
        this.code = RSSNewsR7.easyUrlReader("http://www.heise.de/newsticker/heise.rdf");
        String replace1 = "<rdf:RDF" + NL + "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"" + NL + "xmlns=\"http://my.netscape.com/rdf/simple/0.9/\">";
        String replace2 = "</rdf:RDF>";
        this.code = RSSNewsR7.replaceSubstring(this.code, replace1, "<query>");
        this.code = RSSNewsR7.replaceSubstring(this.code, replace2, "</query>");
        this.code = RSSNewsR7.processCodeSS(this.code, xsl);
        this.code = BEGIN + RSSNewsR7.replaceSubstring(this.code, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "") + END;
    }

    public String getCode() {
        return this.code;
    }

    public void attach(String output) throws NotesException {
        RichTextItem item = null;
        if (this.doc.hasItem(ITEM_BODY)) {
            this.doc.removeItem(ITEM_BODY);
        }
        item = this.doc.createRichTextItem(ITEM_BODY);
        BufferedReader br = new BufferedReader(new StringReader(output));
        try {
            String line = br.readLine();
            while (line != null) {
                item.appendText(line);
                item.addNewLine();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String processCodeSS(String code, String xsl) {
        StringWriter stringwriter = new StringWriter();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = RSSNewsR7.tempfile(code, ".xml");
            org.w3c.dom.Document document = builder.parse(f);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            File fxsl = RSSNewsR7.tempfile(xsl, ".xsl");
            StreamSource streamsource = new StreamSource(fxsl);
            Transformer transformer = tFactory.newTransformer(streamsource);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stringwriter);
            transformer.transform(source, result);
            f.delete();
            fxsl.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringwriter.toString();
    }

    private static File tempfile(String s, String ext) throws IOException {
        String name = String.valueOf(DemoTools.getRandomString(10)) + ext;
        FileWriter fw = new FileWriter(name);
        fw.write(s);
        fw.flush();
        fw.close();
        return new File(name);
    }

    private static String easyUrlReader(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        StringBuffer result = new StringBuffer();
        BufferedReader urlInput = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = "";
        while ((line = urlInput.readLine()) != null) {
            result.append(String.valueOf(line) + "\n");
        }
        urlInput.close();
        return result.toString();
    }

    private static void saveStringToFile(String s, String s1) {
        try {
            FileWriter filewriter = new FileWriter(s1);
            filewriter.write(s);
            filewriter.flush();
            filewriter.close();
            filewriter = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadStringFromFile(String s, int i) {
        String string;
        int j = 32768;
        j = i <= 0 || i >= j ? j : i;
        FileReader filereader = null;
        try {
            String s1 = "";
            try {
                filereader = new FileReader(s);
                StringWriter stringwriter = new StringWriter();
                char[] ac = new char[j];
                int k = 0;
                int l = 0;
                while ((k = filereader.read(ac, 0, ac.length)) > 0) {
                    stringwriter.write(ac, 0, k);
                    if (i > 0 && (l += k) >= i) break;
                }
                s1 = stringwriter.toString();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Object var9_11 = null;
                try {
                    if (filereader != null) {
                        filereader.close();
                    }
                }
                catch (IOException ioexception1) {
                    // empty catch block
                }
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var9_12 = null;
                try {
                    if (filereader != null) {
                        filereader.close();
                    }
                }
                catch (IOException ioexception1) {
                    // empty catch block
                }
                return "";
            }
            string = s1;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            try {
                if (filereader != null) {
                    filereader.close();
                }
            }
            catch (IOException ioexception1) {}
            throw throwable;
        }
        try {
            if (filereader != null) {
                filereader.close();
            }
        }
        catch (IOException ioexception1) {
            // empty catch block
        }
        return string;
    }

    private static String replaceSubstring(String source, String from, String to) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        int j = 0;
        while ((j = source.indexOf(from, i)) >= 0) {
            result.append(source.substring(i, j));
            result.append(to);
            i = j + from.length();
        }
        result.append(source.substring(i));
        return result.toString();
    }
}

