  program FEMGeo_Wr
!-----------------------------------------------------------------------------------!
!  1. General Considerations                                                        !
!  --------------------------                                                       !
!  Wriedt 8.12.2005:                                                                !
!  This program is needed to generate .FEM geometry files for input of 3D particle  !
!  shape data into program TNONAXSYM.                                               !
!  For information on the file format .FEM have a look at the comments in           !
!  program TNONAXSYM.                                                               !
!                                                                                   !
!  The program calls the ivread_wr.f90 subroutine.                                  !
!  This routine is based on the ivread.f90 routine by John Burkardt (1999).         !
!  The program converts various computer graphics files formates                    !
!  (dxf, obj, oogl, smf, vmrl) into the .FEM format needed with TNONAXSYM.          !
!  (Have a look at the comments in inread).                                         !
!                                                                                   !
!  But the focus of the program FEMGeo_Wr is on the wavefront .obj file format.     ! 
!  The input .obj file should such be such that it only consists of triangular (!!) !
!  surface patches! No free form curves are supported.                              !
!  All dimensions are in microns.                                                   !
!                                                                                   !
!  This .obj file format will also be generated by the SScaTT (superellipsoid       !
!  scattering tool), which is also included on this CD.                             !
!  FEMGeo has not been tested with the other file formats that can be read by the   !
!  ivread.f90 routine.                                                              !
!                                                                                   !
!  The Hyperfun program (www.hyperfun.org) is suitable for generation of other      !
!  particle shapes. For conversion to .obj, visualization and scaling you may use   !
!  Deep Exploration (www.righthemisphere.com), for grid reduction you may use       !
!  Rational Reducer Professional (www.rational-reducer.com).                        ! 
!  To increase the number of faces of a body you can use a divide by four           !
!  subdivision scheme implemented in the Triangles                                  !
!  DOS program (www.geocities.com/Athens/Academy/8764/triangdoc.html).              !
!  A divide by three or by four scheme is also included in MilkShape-1.5.7.         !                                                            !
!                                                                                   !
!-----------------------------------------------------------------------------------!
  integer, parameter :: face_max = 100000
  integer na
  integer face_num, n_surfaces
  real face_point(3,face_max)
  real face_normal(3,face_max)
  real face_area(face_max)
  character (len = 100) filein_name,name_out
!
!   only particles consisting of one (!) closed surface are considered 
!
	n_surfaces=1
!
!   .obj input file name
!
	filein_name='sphere-d4-4188.obj'
!
!   .fem output file name
!
    name_out='sphere-d4-4188.fem'
!
	call ivread_wr(filein_name,face_point,face_normal,face_area,face_num)
!
    open (unit=12, file=name_out, status='unknown')
!
	write(12,110) n_surfaces
	write(12,110) face_num
!
	do 10 na=1, face_num
      write(12,120) na, face_point(1,na),face_point(2,na),face_point(3,na), &
	  face_normal(1,na),face_normal(2,na),face_normal(3,na),face_area(na)	 
10  continue
!
110 Format (i7)
120 Format (i7,2x,7(e15.7,2x))
	close(12)
!	   
end

