function a=clean(a, level)
%a=clean(a, level)
% function that resets the parameters of the model.
% If level='all', clears everything.
% Otherwise, clears only big matrices.

% Isabelle Guyon -- isabelle@clopinet.com -- October 2005

clearall=0;
if nargin>1 & strcmp(level, 'all')
    clearall=1;
else
    maxsize=20000;
end

b=struct(a);
fn=fields(b);
if isfield(b, 'display_fields')
    df=b.display_fields;
else
    df=fn
end
for k=1:length(fn)
    % Look for "big" fields
    if ~ismember(fn{k}, df) & isnumeric(b.(fn{k})) & (clearall | prod(size(b.(fn{k})))>maxsize )
        b.(fn{k})=[];
    end
end
% Construct a new object with some fields clear
a=eval([b.algorithm.name, '(b);']);
      
