function [d,a] =  testing(a,d)
%[d,a] =  testing(a,d)
% Ensemble testing.

% Isabelle Guyon -- isabelle@clopinet.com -- October 2005

% Test all the ensemble members
Res=[];
for i=1:length(a.child)
    r=test(a.child{i},d);
    Res(:,i)=get_x(r);
end

% Optionally take the sign
if a.signed_output
    Res=sign(Res);
end

% Vote for the final output
[p, n]=size(Res);
Yest = Res*a.W' + a.b0(ones(p,1),:);

% Remove the ties
zero_val=find(Yest==0);
Yest(zero_val)=a.algorithm.default_output*eps;

d=set_x(d,Yest); 
    
if a.algorithm.use_signed_output
    d=set_x(d, sign(get_x(d)));
end
 
d=set_name(d,[get_name(d) ' -> ' get_name(a)]); 
