function [retDat,algo] =  training(algo,retDat)
%[retDat,algo] =  training(algo,retDat)
% Train a Naive Bayes classifier.
% Inputs:
% algo -- A Naive Bayes classifier object.
% retDat -- A training data object.
% Returns:
% retDat -- The same data structure, but X is replaced by the class label
% predictions on training data.
% algo -- The trained Naive Bayes classifier.

% Isabelle Guyon -- September 2005 -- isabelle@clopinet.com

if algo.algorithm.verbosity>0
    disp(['training ' get_name(algo) '... '])
end

X=get_x(retDat); 
Y=get_y(retDat); 
[p,n]=size(X);

% Check the nature of the features
featval=full(unique(X(:)));
if length(featval)==2
    algo.binary=1;
    if ~(min(featval)==0 & max(featval)==1)
        X(find(X==min(featval)))=0;
        X(find(X==max(featval)))=1;
        if algo.algorithm.verbosity>0
            fprintf('Binary values found, converted to 0/1\n');
        end
    end
else
    algo.binary=0;
end
    
if algo.binary
    param=naivebayes(X, Y);
else
    param=gaussian_train(X, Y);
end
algo.W=param.W;
algo.b0=param.b;

if algo.algorithm.do_not_evaluate_training_error
    retDat=set_x(retDat,get_y(retDat)); 
else
    retDat=test(algo,retDat);
end
        








