function [errate, errate_pos, errate_neg]=balanced_errate(Output, Target)
%[errate, errate_pos, errate_neg]=balanced_errate(Output, Target)
% Compute a "balanced" error rate as the average
% of the error rate of positive examples and the
% error rate of negative examples.
% Inputs:
% Output    --  Classifier outputs in columns of dim (num pattern, num tries)
% Target    -- +-1 target values of dim size(Output,1).
% Returns:
% errate    -- Balanced error rates of all the tries.
% errate_pos -- Error rate of the positive class.
% errate_neg -- Error rate of the negative class.


% Isabelle Guyon -- October 2003 -- isabelle@clopinet.com

if size(Output,1)~=size(Target,1), errate=[]; return; end

Output=full(Output);
Target=full(Target);

pos_idx=find(Target>0);
neg_idx=find(Target<0);
for i=1:size(Output,2)
    errate_pos=mean(Output(pos_idx,i)<0);
    errate_neg=mean(Output(neg_idx,i)>0);
    errate(i)=mean([errate_pos,errate_neg]);
end