function sorted_pval = pval_compute(w, rand_w)
%sorted_pval = pval_compute(w, rand_w)
% Computes pvalues for all the values of the criterion w of the features,
% given values of the same criterion for random features (probes).
% Inputs:
% w      --    Unsorted weights of features.
% rand_w --    Unsorted weights of random probes
% Returns:
% sorted_pval   --    Fraction of random probes that have a larger w value,
%                     sorted in order of increasing pvalues.

% Note: this differs from computing the false discovery rate FDR
% that is the fraction of falsely significant features above value of w. 
% FDR=pval*i/n, where i is the feature rank and n the total number of features.

% Isabelle Guyon -- January 2006 -- isabelle@clopinet.com

if nargin<2, error('Too few arguments'); help('pval_compute'); end

allw=[w, rand_w];
allid=[zeros(size(w)), ones(size(rand_w))]; % Indicate which features are probes

[allws,idx]=sort(-allw);
allws=allw(idx);
allids=allid(idx);
cumul=zeros(size(w));
n=size(w,2);
k=0;
c=0;
for i=1:length(allws)
    if allids(i)==0, 
        k=k+1;
        cumul(k)=c;
    else
        c=c+1;
    end
end
sorted_pval=cumul/length(rand_w);
return