function save_model(filename, model, overwrite_flag)
%save_outputs(filename, model, overwrite_flag)
% Save vectors or matrices in the space delimited format.
% Inputs:
% filename          -- Name of the file to write to.
% model             -- A model (a challenge learning object).
% overwrite_flag    -- 0/1 flag to choose whether the file should be
%                      overwritten if it exists.

% NOTE: You can just use save('modelfile', 'modelname')
% to save a model, if you don't care about overwriting!

% Isabelle Guyon -- October 2005 -- isabelle@xlopinet.com
% after a suggestion of Amir Reza Saffari Azar

if nargin<3,
    overwrite_flag=1;
    % Force overwrite unless precised
end

if isempty(strfind(filename, '.mat'))
    filename=[filename '.mat'];
end
    
ok=1;
if ~overwrite_flag & exist(filename) == 2
	ok=input(['File ' filename ' already exists, overwrite [yes=1/no=0]? ']);
end

if ok 

    save temp12345 model; % ugly but it works
    movefile('temp12345.mat', filename);

end