function [dat] = get(dt,ind,fInd) 

%   data=get(data)                      returns the data of the data_struct object a
%   data=get(data,examIndex,featIndex)  returns the data of the data object 
%                                       for given indexes. Feature indices
%                                       are ignored (type "help data_struct" for more information).

empty=0; 
if nargin>1 
    empty=isempty(ind);  
end;

if (nargin==1 | empty) 
    ind=[1:length(dt.Y)];  %<--- return all examples 
end;  


y=[]; 
if ~isempty(dt.Y) 
    y=get_y(dt,ind); 
end;

x=[]; 
if ~isempty(dt.X) 
    x=get_x(dt,ind); 
end;
  
dat  = data_struct(dt.algorithm.name,x,y); 
dat.index = dt.index(ind);



