function [results,a] =  training(a,d)

TrnPtn=get_x(d);
k=a.child;
% parameters for KHA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    NumofEigenvectors = a.NumofEigenvectors;
    LearningParameter = a.LearningParameter;
    NumofEigenvectors = a.NumofEigenvectors;
    MovementThreshold = a.MovementThreshold;
    IterationLimit = a.IterationLimit;

    if(strcmp(a.child.ker, 'linear') ==1)
        KernelType = 1;
    elseif(strcmp(a.child.ker, 'poly') ==1)
        KernelType = 2;
        PolyDegree = a.child.kerparam;
    else
        KernelType = 3;
    end;
% parameters for KHA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Initialize A: dual variables
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    [NumofPatterns,InputDim] = size(TrnPtn);
    A = rand(NumofEigenvectors, NumofPatterns);
    A = A*2-1;
    AOld = A;
% Initialize A: dual variables
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Compute empirical sum kernel map for each patterns
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    EmpiricalSumKernelMap = zeros(1, NumofPatterns);
    EmpiricalKernelSum = 0;
    for i=1:NumofPatterns
        switch KernelType
            case 1 % linear
                EmpiricalSumKernelMap(i) = sum(TrnPtn(i,:)*TrnPtn');
            case 2 % polynomial
                EmpiricalSumKernelMap(i) = sum((TrnPtn(i,:)*TrnPtn').^PolyDegree);
            otherwise % other kernels
                EmpiricalSumKernelMap(i) = sum(calc(k,d,data(TrnPtn(i,:))));
        end   
    end
    EmpiricalKernelSum = sum(EmpiricalSumKernelMap);
% Compute empirical sum kernel map for each patterns
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% KHA Iteration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    IterationCounter = 0;
    IterationTerminationCondition = -1;
    Movement = 0;
    while IterationTerminationCondition == -1
        % Hebbian iteration
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        
            for i=1:NumofPatterns
                % Prepare empirical kernel map for test pattern i: to compute sum 1
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    switch KernelType
                        case 1 % linear
                            EmpiricalTestKernelMap = TrnPtn(i,:)*TrnPtn';
                        case 2 % polynomial
                            EmpiricalTestKernelMap = (TrnPtn(i,:)*TrnPtn').^PolyDegree;
                        otherwise % other kernels
                            EmpiricalTestKernelMap = calc(k,d,d,[i])';
                    end
                % Prepare empirical kernel map for test pattern i: to compute sum 1
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     
                % Compute output Y
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    Y=zeros(1, NumofEigenvectors);
                    OrthogonalizingTerms=zeros(1, NumofPatterns);

                    Sum1 = EmpiricalTestKernelMap*A';
        
                    Sum2 = EmpiricalSumKernelMap*A';
                    Sum2 = Sum2/NumofPatterns;

                    AlphaSum = sum(A');
                    Sum3 = EmpiricalSumKernelMap(i)*AlphaSum;
                    Sum3 = Sum3/NumofPatterns;
        
                    Sum4 = EmpiricalKernelSum*AlphaSum;
                    Sum4 = Sum4/(NumofPatterns^2);

                    Y=Sum1-Sum2-Sum3+Sum4;
                % Compute output Y
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                % Update A
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                    A = A - LearningParameter*(tril((Y'*Y),0)*A);
                    A(:,i) = A(:,i) + LearningParameter*Y';
                % Update A
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            end
        % Hebbian iteration
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        

        % display status
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
            if mod(IterationCounter,100) == 0
                Movement = mean(mean(abs(AOld-A))); % dual space distance: should be replaced by the feature space distance(||WOld-W||)
                AOld = A;
                disp(sprintf('Iter %d Movement %g', IterationCounter, Movement));
                pause(0.001);
            end
        % display status
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   

        % update learning rate
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            IterationCounter = IterationCounter+1;
            %~ LearningParameter = LearningParameter*0.99;
            %~ if LearningParameter < 0.00001
                %~ LearningParameter = 0.00001;
            %~ end
        % update learning rate
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        % check termination condition
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            if Movement < MovementThreshold
                IterationTerminationCondition = 1;
            elseif IterationCounter > IterationLimit
                IterationTerminationCondition = 1;
            end
        % check termination condition
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
% KHA Iteration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Normalize eigenvectors in feature space
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for i=1:NumofEigenvectors
    FNorm = 0;
    for j=1:NumofPatterns
        for k=1:NumofPatterns
            switch KernelType
                case 1 % linear
                    FNorm = FNorm + A(i,j)*A(i,k)*(TrnPtn(j,:)*TrnPtn(k,:)');
                case 2 % polynomial
                    FNorm = FNorm + A(i,j)*A(i,k)*((TrnPtn(j,:)*TrnPtn(k,:)')^PolyDegree);
                otherwise % other kernels
                    FNorm = FNorm + A(i,j)*A(i,k)*get_kernel(a.child,d,d,[j],[k]);
            end   
        end
    end
    if FNorm ~= 0
        A(i,:) = A(i,:)/sqrt(FNorm);
    end
end
% Normalize eigenvectors in feature space
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

a.e_vec=A'; %store eivenvectors
a.e_val=zeros(1,NumofEigenvectors); % store eigenvalues: zero
a.dat=d; % store training data
a.EmpiricalSumKernelMap = EmpiricalSumKernelMap;
a.EmpiricalKernelSum = EmpiricalKernelSum;
results=test(a,d); % extract features from training data
