function a = kvq(hyper)   
%================================================================================   
% KVQ kpca object - Kernel Vector Quantization
%================================================================================    
% A=KVQ(H) returns a kvq object initialized with hyperparameters H.   
%  
% Hyperparameters, and their defaults  
%  dist=1;          -- allowed point to point distortion.
%  child=linear         -- child stores the kernel. The kernel induced the used distance measure. 
%  a.cutoff = 1./3.      -- cutoff value for importance values
%  a.return_indices = 0   -- return indices of points instead of samples.
% Model  
% a.keep                -- kept data points -- store data points kept for model       
% a.alpha               -- importance factors
% Methods:  
%  train, test  
%
% Example: 
%  d=gen(toy('n=2'));
%  [r,a]=train(kvq,d)
%  plot(a,d)
%================================================================================
% Reference : A kernel approach vor vector quantization with guaranteed distortion bounds
% Author    : M. Tipping, B. Schlkopf
% Link      : ftp://ftp.research.microsoft.com/users/mtipping/aistats01.ps.gz
%================================================================================
    
  %hyperparams   
  a.dist=1;  
  a.child=kernel;  

  % cutoff value for samples.
  a.cutoff=1./3.;
  
  % return indices of points instead of samples.
  a.return_indices=0;
  % model   
  a.alpha =[];
  a.keep=[];

  p=algorithm('kvq');  
  a= class(a,'kvq',p);  
   
  if nargin==1,  
    eval_hyper;  
  end;  
 
