function a = nmf(hyper) 

%============================================================================================  
% nmf spider object
%============================================================================================   
% A=nmf(H) returns a Non-negative Matrix Factorization object.
% Given matrix X>0   creates matrices W,H>0 with X ~ X*=W*H
% Usage:  [r n]=train(nmf,data(abs(rand(nrofsamples,nroffeatures))));
% Result: r.X = approximated X*  , r.Y= original X
%  implementation for the MPG journal club. faster code available from the seungs lab.
%
% 
%  Hyperparameters, and their defaults
%
%   N=5; 	            -- number of final basis functions
%   maxIteration=50;    -- maximum number of iterations per cycle
%   nrofrestarts=5;     -- nr of restarts to overcome local minima.
%   
%  Model
%
%   W  =            new coordinates of object.
%   H  =            new basis vectors.
% 
%  Methods:
%
%   train 
%   testing 
%  Example:
%   d=data(rand(20,10));
%   [r,n]=train(nmf('N=2'),d);
%=============================================================================================
% Reference : Algorithms for Non-negative Matrix Factorization
% Author    : Daniel D. Lee, H. Sebastian Seung
% Link      : http://citeseer.ist.psu.edu/lee00algorithms.html
%=============================================================================================

 % hyperparams 
  a.N=[];

  a.maxIteration=50;

  a.W=[];
  a.H=[];
  
  a.eps=1e-3;
  a.nrofrestarts=5;
  

  
  p=algorithm('nmf');
  a= class(a,'nmf',p);
 
 % a.algorithm.alias={'W','H','N','nrofrestarts','maxIteration'}; % 
 
  if nargin==1,
    eval_hyper;
  end;
