function [d,a] =  training(a,d)

disp(['training ' get_name(a) '.... '])

switch a.optimizer
    
case {'andre_c'}
    
    K=train(a.child,d); K=K.X;  % calc kernel
    m=length(K);
    alpha = quadsolve(K,-ones(m,1),[],0,a.C);
    a.alpha=alpha;
    a.b0=0;
    a.Xsv=d;
    
case {'quadprog_c'}
    
    K=train(a.child,d); K=K.X;  % calc kernel
    m=length(K);
    opts=optimset('LargeScale','off');
    [alpha,fval,exitflag,output,lambda]=quadprog(K,-ones(m,1),[],[],[],[],zeros(m,1),ones(m,1)*a.C,[],opts);
    a.alpha=alpha;
    a.b0=0;
    a.Xsv=d;
    
case {'quadprog'}
    
    K=train(a.child,d); K=K.X;  % calc kernel
    m=length(K);
    opts=optimset('LargeScale','off');
    [alpha,fval,exitflag,output,lambda]=quadprog(K,zeros(m,1),[],[],ones(1,m),1,zeros(m,1),ones(m,1)/(a.nu*m),[],opts);
    a.alpha=alpha;
    a.b0=lambda.eqlin;
    a.Xsv=d;
    
case {'andre'}
    error('Not implemented yet');
    
    
case {'libsvm'}
    
    %% default values for libsvm
    cache_size = 40;
    eps = 0.001;
    shrinking=1;
    nr_weight = 0;
    weight_label =0;
    weight = 1;
    gamma=1;
    C=1; 
    epsilon=-1;
    svm_type = 2;
    deg = 0;
    coef0 = 0;
    nu = a.nu; 
    kertmp = a.child; 
    if strcmp(kertmp.ker,'linear')
        kernel_type = 0;
    end;
    if strcmp(kertmp.ker,'poly')
        kernel_type = 1;   
        deg = kertmp.kerparam;
        %deg = optcell.deg;
        coef0 = 1;
    end;
    if strcmp(kertmp.ker,'rbf'),
        kernel_type = 2;
        sigma = kertmp.kerparam;
        %sigma = optcell.sigma;
        gamma = 1/(2*sigma^2);
    end;
    Y=get_y(d);
    X=get_x(d);
    
    [alpha,b0,Xsv,eps,CC] = libsvm_spider(X,Y,svm_type,kernel_type,deg,gamma,coef0,nu,cache_size,C,eps,epsilon,shrinking,nr_weight,weight_label,weight,0);    
    b0=-b0;% from libsvm
    
    % Reorder the alpha to have the same Xsv for all runs
    % this is important for one_vs_rest
    alphatmp = zeros(size(Xsv,1),1);
    indtmp = find(Xsv(:,size(Xsv,2))~=0);
    indtmp2 = Xsv(indtmp,size(Xsv,2));
    alphatmp(indtmp2) = alpha(indtmp);
    alpha = alphatmp;
    endq
    
    a.alpha=alpha;
    % a.b0=b0;
    a.Xsv=d;
end
if a.algorithm.do_not_evaluate_training_error==1   
    d=set_x(d,get_y(d));
else
    d=test(a,d);
end
