function [results,a] =  training(a,dat)

X = get_x(dat); %get the data
mu = mean(X); % calculate mean

X = (X-repmat(mu,size(X,1),1)); %center data 

a.offset = mu; % store mean as offset


if a.feat == 0
    q = size(X,2); %number of principal axes, we want to compute
    a.feat = q;
else
    q = a.feat;
end

%-----calculation of some parameters-------
d = size(X,2);N = size(X,1);
S = X'*X; % compute the covariance matrix
W = rand(size(X,2),q); %initialize the principal axes randomly
Psi = rand; % initialize sigma^2*I
 
%------------------------------------------

%------- EM-Algorithm ------------------------
L_old = -Inf;
for i = 1:a.iterations
     
     M = W'*W+eye(q)*Psi;
     Wtmp = S*W*inv(eye(q)*Psi + inv(M)*W'*S*W);
     Psi = diag((1/d)*trace(S - S*W*inv(M)*Wtmp'));
     W = Wtmp;
     
    if mod(i,1) == 1000
        C = W*W' + eye(d)*Psi;
        lndetC = 2*sum(log(diag(chol(C))));
        L = -0.5*N*(d*log(2*pi)+lndetC + trace(inv(C)*S));
        disp(['Loglikelihood at iteration ' num2str(i) ' is ' num2str(L)])
        if (L_old > L)
            disp('VIOLATION')    
        else
            L_old = L;
        end
    end
     
 end

%---------------------------------------------


%---compute the true principal axes
[u v] = eig(W'*W);
[tmp ind] = sort(-diag(abs(v)));
wtmp = W*u;
for i = 1:a.feat
    wtmp(:,i) = wtmp(:,i)/norm(wtmp(:,i));
end

a.e_vec = wtmp(:,ind);
a.e_val = diag(v);
a.W = W;
a.sigma = Psi;

results = test(a,dat);