import string, os

acceptedchars = string.letters + string.digits + '_'

basedir = "./"

def GetMatlabFiles( basedir ):
    matlabfiles = []
    folders = []
    thisdir = os.listdir( basedir )
    for e in thisdir:
        if string.count( e, '.' ):
            pass
        else:
            folders.append( basedir + e + '/' )
    folders.remove( basedir + 'functions/' )
    folders.remove( basedir + 'Optimization/' )
    for e in folders:
        thisfolder = os.listdir( e )
        if e == (basedir + 'demos/'):
            thisfolder.remove( 'Contents.m' )    
        for c in thisfolder:
            thisclass = os.listdir( e + c )
            for f in thisclass:
                if f[-2:] == '.m':
                    matlabfiles.append( e + c + '/' + f )
    return matlabfiles
    
def GetExceptionsMatFiles( basedir ):
    excepfiles = []
    excepfiles.append( basedir + 'Contents.m' )
    functionsfolder = os.listdir( basedir + 'functions/' )
    for f in functionsfolder:
        if f[-2:] == '.m': excepfiles.append( basedir + 'functions/' + f )
    return excepfiles        
 
def GetConstrList( basedir ):
    constrlist = []
    folders = []
    thisdir = os.listdir( basedir )
    for e in thisdir:
        if string.count( e, '.' ):
            pass
        else:
            folders.append( basedir + e + '/' )
    folders.remove( basedir + 'functions/' )
    folders.remove( basedir + 'Optimization/' )
    folders.remove( basedir + 'demos/' )
    for e in folders:
        thisfolder = os.listdir( e )
        for c in thisfolder:
            dst = string.replace( c, '@sp_', 'sp_' )
            src = string.replace( c, '@sp_', '' )
            constrlist.append( [src, dst] )
    return constrlist

def ParseLine( line, key, dst ):
    first = line.find( key )
    newline = line
    while first != -1:
        lenk = len(key)
        lend = len(dst)
        low = first - 1
        up  = first + lenk
        bReplace = 1
        if bReplace and low >= 0:
            check = newline[low]
            if check in acceptedchars:
                bReplace = 0
        if bReplace and up <= len(newline):
            check = newline[up]
            if check in acceptedchars:
                bReplace = 0
        if bReplace:
            left = newline[:first]
            right = newline[first:]
            newright = right.replace( key, dst, 1 )
            newline = left + newright
        first = newline.find( key, first+lend )
    return newline        
    
    
matfiles = GetMatlabFiles( basedir ) + GetExceptionsMatFiles( basedir )
constructors    = GetConstrList( basedir )


for matfile in matfiles:
    dstfile = matfile + '.new'
    print matfile
    f = open( matfile )
    lines = f.readlines()
    newlines = []
    for l in lines:
        l.strip
        newl = l
        for c in constructors:
            newl = ParseLine( newl, c[0], c[1] )
        newlines.append( newl )                             
    f.close()                    
    g = open(dstfile, "w" )
    for nl in newlines:
        g.write(nl)
    g.close()
    os.remove( matfile )
    os.rename( dstfile, matfile )   
    