/* $Revision: 1.3 $ */
// Automatically generated by MATLAB Project Wizard version 1.0

//
// This is the gateway routine for a MATLAB Math/Graphics Library-based
// C MATLAB MEX File.

#include "mex.h"
#include <string.h>
#include <stdio.h>







void mexInfo()
{
	mexPrintf("Version : %s -- %s\n",__DATE__,__TIME__);
	mexPrintf("Matlab Spider Interface for exporting to external model files. -gb-\n");
	mexPrintf("export(obj  ,'<filename>')\n");
}








void write_data(FILE *f,const mxArray*Obj);











void mexFunction(
				 int nlhs,              // Number of left hand side (output) arguments
				 mxArray *plhs[],       // Array of left hand side arguments
				 int nrhs,              // Number of right hand side (input) arguments
				 const mxArray *prhs[]  // Array of right hand side arguments
				 )
{
	
	char FileName[256];
	char *ObjName;
	FILE *f;
	
	if(nrhs==2)
	{
		
		if(mxGetClassID(prhs[0]) ==mxOBJECT_CLASS)
		{
			// first arg is object to export
			
			ObjName=(char *)mxGetClassName(prhs[0]);
			
			
			
			if(strcmp(ObjName,"data")==0)
			{
				mxGetString(prhs[1],FileName,256);
				
				f=fopen(FileName,"wt");
				
				if(f)
				{
					write_data(f, prhs[0]);
					fclose(f);
				}
				
				
				
				
			}
			else
			{
				mexPrintf("Object: <%s>  not yet exportable\n",ObjName);
			}
			
			
			
			
		}
		
		
		
		
		
		/*			export (obj, 'optimizer','purpose')
		
		  export(d,'libsvm','classify')
		  export(d,'libsvm','regress')
		  export(d,'libsvm','oneclass')
		  
			
			  export(d,'svmlight','classify')
			  export(d,'svmlight','regress')
			  export(d,'svmlight','oneclass')
		*/
		
	}
	else mexInfo();
}






// ============================================================================================
// ============================================================================================

#define  MemBlock  (20000)

long mptr;
char *Memory;
FILE *f;

void initwriting(file)
{
	mptr=0;
	Memory=(char*)mxMalloc(MemBlock);
	f=file;
}
void emptybuffer()
{
	fwrite(Memory,mptr,1,f);
	

	mptr=0;
}

void writebuffered(str)
{
	int wlen=strlen(str);
	
	if(wlen+mptr<MemBlock)
	{
		strcpy(Memory+mptr,str);
		mptr+=wlen;
	}else
	{
		emptybuffer();
		
		
		strcpy(Memory,str);
		mptr+=wlen;
	}
}

void endwriting()
{
	if(mptr>0)
	{
		fwrite(Memory,mptr,1,f);
	}
	
	mxFree(Memory);
	mexPrintf("Done!\n");	
}


// ============================================================================================
//	write_libsvm_classification
// ============================================================================================

int matlabindex(int i,int j,int m,int n) { return ( (j)*(m)+(i));}


void write_data(FILE *f,const mxArray*Obj)
{
	int i,j;
	
	double nrofsamples;
	double idimsize;
	double odim;
	double odimsize;
	int nlhs=4;
	mxArray *lhs[4];
	
	
	mxArray *X; double *Xd,*Yd;
	mxArray *Y;
	char Buffer[256];
	
	
	
	
	mexCallMATLAB(4,lhs ,1,&Obj,"get_dim");
	
	mexCallMATLAB(1,&X ,1,&Obj,"get_x");
	mexCallMATLAB(1,&Y ,1,&Obj,"get_y");
	
	
	
	
	
	nrofsamples=mxGetM(X);
	idimsize=mxGetN(X);
	
	odimsize=mxGetN(Y);

	Xd=mxGetPr(X);
	Yd=mxGetPr(Y);
	
	
	initwriting(f);
	
	for( i= 0;i<nrofsamples; i++)
	{
		if(Yd)
		{	sprintf(Buffer,"%f  ",Yd[matlabindex(i,0,nrofsamples,1)]);		writebuffered(Buffer);}
		else
		{
			sprintf(Buffer,"0  ");	writebuffered(Buffer);
		}

		
		for( j= 0;j<idimsize; j++)
		{			
			sprintf(Buffer,"%d: %lf\t",j+1, Xd[matlabindex(i,j,nrofsamples,idimsize)]);		writebuffered(Buffer);			
			
		}
		sprintf(Buffer,"\n");		writebuffered(Buffer);
	}
	
	endwriting();
	
}
