
function a = loom(hyper) 
 
%================================================================================  
% LOOM loom object - Leave One Out Machine
%================================================================================  
% A=LOOM(H) returns a loom object initialized with hyperparameters H. 
%
% Hyperparameters, and their defaults
%  R=1                  -- the soft margin parameter K=K-R*diag(diag(K))
%  A=0.001;             -- additional regularization on alphas, A*||alpha||_1
%  ridge=1e-12;         -- a ridge on the kernel
%  balanced_ridge=0     -- for unbalanced data
%  child=kernel         -- the kernel is stored as a member called "child"
% 
% Model
%  alpha                -- the weights
%  b0                   -- the threshold
%  Xsv                  -- the Support Vectors
%
% Methods:
%  train, test
%=================================================================================
% Reference : Leave One Out Error, Stability, and Generalization of Voting Combinations of Classifiers
% Author    : Theodoros Evgeniou ,Massimiliano Pontil , Andr Elisseeff 
% Link      : http://portal.acm.org/citation.cfm?id=974025.974029&dl=GUIDE&dl=GUIDE
%=================================================================================

  %hyperparams 
  a.A=0.001;
  a.R=1;
  a.ridge=1e-12;
  a.balanced_ridge=0;
  a.child=kernel;
  
  % model 
  a.alpha=[];
  a.b0=0;
  a.Xsv=[];
  
  p=algorithm('loom');
  a= class(a,'loom',p);
 
  if nargin==1,
    eval_hyper;
  end;
