function a = rsc_learn(alg, hyper) 

%=================================================================
% RSC_LEARN reduced set construction - learning pre-images
%=================================================================
% a = rsc_learn(alg,hyper)
% generates a rsc object, using the learning pre-images method
%
% hyperparameters:
% child=svm     algorithm worked on
% rsv=.5        if rsv e [0,1): #rsv = #sv * rsv
%               if rsv > 1: #rsv
% ridge=1e-5    ridge for ridge regression
% rr_k=rbf,1    kernel for regression estimation
% 
% model:
% alpha         new alphas for rs-vectors
% Xsv           rs vectors
%
% stats:
% w2=0          final value of ||w-w*||^2 
% delta_w=0     total decrease in ||w-w*||^2 
% dw=0          run through delta_w
%
% methods:
% train         constructs a reduced set, returns trained rs-machine
% test          tests new rs-machine on supplied data
%
% example:
% d=gen(toy2d('2circles','l=100'));
% [r,a]=train(svm({kernel('rbf',1),'C=10000','alpha_cutoff=1e-2'}),d);
% [r,a2]=train(rsc_learn(a,'rsv=.9'),d);
% test(a2,d,loss)
%
%=================================================================
% author: goekhan BakIr, philipp berens
% reference: learning to find pre-images, G. BakIr, 2004
%=================================================================


  % hyperparameters
  a.C=Inf;
  a.ridge = 1e-5;
  a.rsv = .5;
  a.child = svm;
  a.rr_k = kernel('rbf',1);
  a.norm = 1;

  % model 
  a.alpha=[];
  a.b0=0;
  a.Xsv=[];
  
  % stats
  a.w2 = 0;
  a.delta_w = 0;
  a.dw = 0;
   
  if nargin==0
    a.child=svm;  
  else 
    a.child=alg; %% algorithm to use  
  end
  
  p = algorithm('rsc_learn');
  a = class(a,'rsc_learn',p);
  
  if nargin==2
    eval_hyper;
  end  