function a = rsc_mds(alg, hyper) 

%=================================================================
% RSC_MDS reduced set construction - using MDS
%=================================================================
% a = rsc_mds(alg,hyper)
% generates a rsc object, using the MDS pre-images method
%
% hyperparameters:
% child=svm     algorithm worked on
% rsv=.5        if rsv e [0,1): #rsv = #sv * rsv
%               if rsv > 1: #rsv
% nn=10         neighbours to use for distance constraints
% map='rbf_map' supply function name to be called for calculating 
%               input space distances from feature space distances
%               must be supplied in rsc_mds directory
% 
% model:
% alpha         new alphas for rs-vectors
% Xsv           rs vectors
%
% stats:
% w2=0          final value of ||w-w*||^2 
% delta_w=0     total decrease in ||w-w*||^2 
% dw=0          run through delta_w
%
% methods:
% train         constructs a reduced set, returns trained rs-machine
% test          tests new rs-machine on supplied data
%
% example:
% d=gen(toy2d('2circles','l=100'));
% [r,a]=train(svm({kernel('rbf',1),'C=10000','alpha_cutoff=1e-2'}),d);
% [r,a2]=train(rsc_mds(a,'rsv=.9'),d);
% test(a2,d,loss)
%
% remark: supports only rbf kernels up per default!
%
%=================================================================
% author: Goekhan BakIr, Philipp Berens
% reference: The Pre-Image Problem in Kernel Methods, J.T.Kwok, 2004
%=================================================================


  % hyperparameters
  a.C=Inf;
  a.rsv = .5;
  a.child = svm;
  a.nn = 10;
  a.map='rbf_map';

  % model 
  a.alpha=[];
  a.b0=0;
  a.Xsv=[];
  
  % stats
  a.w2 = 0;
  a.delta_w = 0;
  a.dw = 0;
   
  if nargin==0
    a.child=svm;  
  else 
    a.child=alg; %% algorithm to use  
  end
  
  p = algorithm('rsc_mds');
  a = class(a,'rsc_mds',p);
  
  if nargin==2
    eval_hyper;
  end  