function [d, a] =  training(a,d)
  
  
  if a.algorithm.verbosity>0
    disp(['calculating reduced set vectors by MDS method for ', get_name(a.child)])
    disp('initializing...')
  end
  
  % train algorithm first
  if isempty(a.child.alpha) | ~isempty(a.alpha) 
   [r a.child]=train(a.child,d);
  end    
  
  % set RNG
  rand('state',sum(100*clock));             
  
  % get data from old algo
  k = a.child.child;
  alpha = a.child.alpha;                    
  svs = find(sum(abs(alpha)',1)>1e-5);
  alpha = alpha(svs);
  Xsv = get(a.child.Xsv,svs);    
  range = max(max(abs(Xsv.X)));
  dim = size(Xsv.X,2);
  Kxx = calc(k,Xsv);
  a.child.Xsv = Xsv;
  a.child.alpha = alpha;
  
  % calculate desired # of rsvs
  if a.rsv < 1
      a.rsv = ceil(sum(abs(alpha)>0) * a.rsv);
  end;
  
  disp(['compressing for ', num2str(a.rsv) , ' rsvs']);

  dw(1) = alpha' * Kxx * alpha;

  gamma = alpha;
  z = Xsv.X;
  Kzz = calc(k,data(z));
  it = 1;
  while size(z,1) > a.rsv
    disp(['compression progress ', num2str(it/(size(Xsv.X,1) -a.rsv)*100), '%'])
    [i,j] = find_closest(k, Kzz, z);
    x_i = z(i,:);
    x_j = z(j,:);
    df = get_feature_space_dist(x_i,x_j,z,k);
    [z_nn df] = near_neighbour(df, z, a.nn);
    di = feval(a.map,a,x_i,x_j,z_nn',df,k);
    
    % bakirs method
    x = (mean(z_nn'))';
    z_nn = z_nn - repmat(x,1,size(z_nn,2));
    d0 = diag(z_nn'*z_nn);

%     method from kwok et al. 
%     % perform singular value decoposition and get projections
%     [U L V] = svd(z_nn*H);
%     Zsvd = L * V';
%   
%     % calculate centroid distances
%     d0 = get_centroid_dist(Zsvd);
%     tmp_z = -.5 * pinv(L') * V' *  (di' - d0);
%   
%     tmp_x = U*tmp_z + xc;

    tmp_x = .5* minres(2*z_nn*z_nn', z_nn * (d0-di')) + x;
    z([i,j],:) = [];
    if size(z,1)~=0
      kzz = calc(k,data(z),data(tmp_x'));
      z = [z; tmp_x'];
      Kzz([i,j],:)=[];
      Kzz(:,[i,j])=[];
      Kzz = [Kzz; kzz];
      Kzz = [Kzz, [kzz';calc(k,data(tmp_x'))]];  
      gamma = minres(Kzz, calc(k, Xsv, data(z))*alpha);
    else
      z = [z;tmp_x'];  
      Kzz = calc(k,data(tmp_x')); 
      gamma = calc(k, Xsv, data(z))*alpha;
    end;    

    dw(it+1) = fz(z(size(z,1),:)',a.child,z,gamma,Kxx);
    it = it+1;
end;

% set results
a.w2 = dw(length(dw));
a.delta_w = dw(1) - a.w2;
a.dw = dw;
a.Xsv = data(z);
a.alpha = gamma;
a.b0 = a.child.b0;

disp(' ')
disp(' ')
disp(' ')
disp('------------------------------------------------------')
disp('stats for reduced set contruction with MDS method')
disp('------------------------------------------------------')
disp(['original support vectors: ' num2str(sum(abs(alpha)>0))]);
disp(['reduced set vectors found: ' num2str(a.rsv)]);
disp(['decrease in ||w-w*||^2: ' num2str(a.delta_w)]);
disp(['final value of ||w-w*||^2: ' num2str(a.w2)]);
disp('------------------------------------------------------')

  
d = test(a,d);

% % subfunction get input space distance
% function ret = get_input_space_dist(x_i,x_j,z_nn,df,k)
% % calculates input space distances of a point,
% % regarding the feature space distances df
% switch k.ker
% case 'rbf'
%   for i=1:size(z_nn,1)
%       Kx = .25 * (calc(k,data(x_i)) + calc(k,data(x_j)) + 2*calc(k,data(x_i), data(x_j)));
%       Ki = calc(k, data(z_nn(i,:)));
%       arg = .5*(Kx + Ki - df(i));
%        if arg <= 0
%            disp('negative logarithm argument - no input distance computable... aborting.')
%            return;
%        else 
%            ret(i) = -2*k.kerparam^2 * log(arg);
%        end;
%   end;
% otherwise
%  ret = NaN;
%  disp('kernel type not supported')
%  return;
% end;


% subfunction near_neighbour
function [z_nn, d_ret] = near_neighbour(d, z, nn)
d_ret = [];
z_nn= [];
if size(z,1) < nn
 nn = size(z,1);
else
 nn = nn;
end;
for i = 1:nn
  [n index] = min(abs(d));
  d_ret(i) = n;
  z_nn(:,i) = z(index,:)';
  d(index) = [];
  z(index,:) = [];
end;


% subfunction get_feature_space_dist
function ret = get_feature_space_dist(x_i,x_j,z,k)
% calculates feature space (ker) distances of a point
c = .25 * (calc(k,data(x_i)) + calc(k,data(x_j)) + 2*calc(k,data(x_i), data(x_j)));
for i=1:size(z,1)
 ret(i) =  c + calc(k,data(z(i,:))) - calc(k,data(x_i), data(z(i,:))) -calc(k,data(x_j), data(z(i,:)));
end

% subfunction get_centroid_distance
function ret = get_centroid_dist(Z)
% calculates d0 = ||z||^2
ret = zeros(size(Z,2),1);
for i = 1:size(Z,2)
  ret(i) = (norm(Z(:,i)))^2;
end;

% subfunction fz
function ret = fz(x0, a, Z, G, K)
% returns value of target function ||w-w*||^2
x0 = x0';
Z(size(Z,1), :) = x0;
ret = a.alpha' * K * a.alpha + G' * calc(a.child, data(Z)) * G - 2 * a.alpha' * calc(a.child, data(Z), data(a.Xsv.X)) * G;

% subfunction find_closest
function [i,j] = find_closest(k, K, z)
% returns indices of closest elements in feature space
if strcmp(k.ker,'rbf')
    K = K - diag(diag(K));
    [K1 I] = max(K);
    [tmp J] = max(K1);
    i = I(J);
    j = J;
else
     K = K - diag(diag(K));
     
     for i=1:size(K,1)
         for j=i:size(K,2)
             K(i,j) = K(i,j) / sqrt(calc(k,data(z(i,:)))*calc(k,data(z(j,:))));
             K(j,i) = K(i,j);
         end;
     end;
     [K1 I] = max(K);
     [tmp J] = max(K1);
     i = I(J);
     j = J;
end;


