
function a = rss_l0(alg,hyper) 

%=================================================================
% RSC_l0 reduced set selection
%=================================================================
% a = rss_l0(alg,hyper)
% generates a rss object, using the l0 norm
%
% hyperparameters:
% child=svm         algorithm worked on
% reoptimize_b=1    recalculate the threshold b0
% a.lambda=0        regularizer for selection
%                   set to -1 for automatic selection
% reoptimize=1    
% tolerance=0.05    tolerance in ||w-w*||^2 
% max_loops=40      limit on loops
% 
% 
% model:
% alpha         new alphas for rs-vectors
% Xsv           rs vectors
% b0            the threshold
% w2            final value of ||w*-w^2||^2, set to -1 to calculate
%
% stats:
% w2=0          final value of ||w-w*||^2 
% res=[]        results on a separate test set
% dtst=[]       separate test set  
% test_on=0     iterations to test on
%
% methods:
% train         constructs a reduced set, returns trained rs-machine
% test          tests new rs-machine on supplied data
%
% example:
% d=gen(toy2d('2circles','l=100'));
% [r,a]=train(svm({kernel('rbf',1),'C=10000','alpha_cutoff=1e-2'}),d);
% [r,a2]=train(rss_l0(a,'lambda=1e-2'),d);
% test(a2,d,loss)
%
%=================================================================
% author: goekhan bakir, jason weston
% reference: fast binary and multi-output rss, 2004
%=================================================================
  
  %hyperparams 
  a.child=svm;
  a.lambda=0;  % set to -1 to set automatically as  0.01 mean_i ||w_i||^2
  a.reoptimize=1;
  a.reoptimize_b=1;
  a.tolerance=0.05; 
  a.max_loops=40;
  
  % model 
  a.alpha=[];
  a.Xsv=[];  
  a.b0=0;
  a.w2=0;  % final value of ||w*-w^2||^2
  
  if nargin==0
    a.child=svm;  
  else 
    a.child=alg; %% algorithm to use  
  end
  
  p=algorithm('rss_l0');
  a= class(a,'rss_l0',p);
  a.algorithm.use_signed_output=0;
  
  if nargin==2
    eval_hyper;
  end  
  
 
