
function a = gproc(hyper,length) 

%=========================================================================   
% GPROC Gaussian-Process object
%=========================================================================   
% A=GPROC(hyper) returns a GPROCobject initialized with hyperparameters hyper. 
% minimize log-likelihood for length runs
%
% 
%  Hyperparameters, and their defaults
%
% 
%   child=kernel;        -- the kernel is stored as a member called "child"
%   length=50            -- default maximum length lines searches
%  
%  Model
%  H			-- covariance hyperparameters
%  var			-- predictive variances
% 
%  Methods:
%
%   train, test
%=========================================================================
% Reference : Gaussian Processes A Replacement for Supervised Neural Networks
% Author    : David J.C. MacKay
% Link      : http://citeseer.ist.psu.edu/mackay97gaussian.html
%=========================================================================

  % hyperparams 
  a.input= [];
  a.target = [];
  a.length=50;
  a.H=[];
  a.var=[];
  % model     
    
  p=algorithm('gproc');
  a= class(a,'gproc',p);
  a.algorithm.use_signed_output=0;
 
  if nargin==2
    eval_hyper;
  end;
  
  
