function weig = get_w(sv,method) 
% w = get_w() 
% returns value of w from lms

kerTemp = sv.child.kerparam;
if strcmp(sv.child.ker,'linear')
  weig=sv.alpha'*get_x(sv.X);
  return;
end

if strcmp(sv.child.ker,'weighted_linear')
  numEx=get_dim(sv.X);
  weig=sv.alpha'* (get_x(sv.X) .*  repmat(kerTemp,numEx,1));
  return;
end

if strcmp(sv.child.ker,'rbf')  | strcmp(sv.child.ker,'poly'),
    xTemp = get_x(sv.X);
    alphaTemp = sv.alpha;
    
    if strcmp(sv.child.ker,'rbf'),
      % compute the kernel matrix for all components
      kern = xTemp*xTemp';
      kernDegN = sum(xTemp.^2,2);
   %   Kn = sum(xTemp.^2,2);
      kern = ones(size(xTemp,1),1)*kernDegN' + kernDegN*ones(1,size(xTemp,1)) - 2*kern;
      kern = exp(-kern/(2*kerTemp));
      % compute the margin when one component is removed
       for i = 1:size(xTemp,2),
           kern_i = xTemp(:,i)*ones(1,size(xTemp,1)) - ones(size(xTemp,1),1)*xTemp(:,i)';
           kern_i = kern_i.^2;
           kern_i = kern_i/(2*kerTemp); 
           kern_i = exp(kern_i);
           weig(i) = (alphaTemp'*(kern.*kern_i)*alphaTemp);
       end;
    elseif strcmp(sv.child.ker,'poly'),
        % compute the margin when one component is removed
        kernTemp = xTemp*xTemp';
        for i = 1:size(xTemp,2),
           kern_i = xTemp(:,i)*xTemp(:,i)';
           K_i = (kernTemp - kern_i+1).^(kerTemp);           
           weig(i) = (alphaTemp'*K_i*alphaTemp);
    	end;    
    end;% if strcmp(...,'rbf')
    weig=max(weig)-weig;  %% make largest the smallest --- wrong way round!
    return;
end;% if strcmp(... | strcmp(...,'poly')
%%% if this point is reached then the kernel is a non classic one
ker=sv.child.ker;
if strcmp(ker,'custom'),
    error('Get w not implemented for CUSTOM kernels.');
    return;
end;
%%% if tpoly kernel -> used for nfe
if strcmp(ker,'tpoly'),
    [numEx,vDim,oDim]=get_dim(sv.X);    
    xTemp = get_x(sv.X);
    alphaTemp = sv.alpha;
    weig = ones(length(sv.child.param,vDim));
    
    for j=1:length(sv.child.kerparam),  
        ktmp = sv.child;
        kerp = ktmp.kerparam;
        for i = 1:length(kerp{j}),
            kerptmp=kerp;
            kerptmp{j} = [kerp{j}(1:i-1),kerp{j}(i+1:length(kerp{j}))];    
            ktmp.kerparam=kerptmp;
            K_i = get_kernel(ktmp,sv.X,sv.X);            
            weig(j,kerp{j}(i)) = (alphaTemp'*K_i*alphaTemp);
        end; 
    end;
    weig = max(max(weig))-weig;
    return;
end;
for i = 1:size(xTemp,2),
    datTemp = data('tmp',[xTemp(:,1:(i-1)),xTemp(:,(i+1):size(xTemp,2))],[]);
    kern_i = get_kernel(sv.child,datTemp,datTemp);      
    weig(i) = (alphaTemp'*kern_i*alphaTemp);
end;   
weig=max(weig)-weig;