  
function a = lms(hyper)   

%=========================================================================      
% LMS lms object  
%=========================================================================    
% A=LMS(H) returns a lms object initialized with hyperparameters H.   
%  
% Hyperparameters, and their defaults  
%  ridge=1e-13;         -- a ridge on the kernel  
%  indices = []         -- indices of a reduced set of centers to be used  
%                          for learning. ([] means use all training set)  
%  balanced_ridge=0;    -- for unbalanced data  
%  child=kernel;        -- the kernel is stored as a member called "child"  
%  use_b=1              -- find a threshold, otherwise fix to 0   
%  
% Model  
%  alpha                -- the weights  
%  b0                   -- the threshold  
%  X                    -- the set of centers  
%  
% Methods:  
%  train, test, get_w   
%=========================================================================    
% Reference : chapter 5 (Richard O. Duda and Peter E. Hart) Parzen Windows
% Author    : Richard O. Duda , Peter E. Hart
% Link      : http://www.amazon.com/exec/obidos/tg/detail/-/0471056693/002-6279399-2828812?v=glance
%=========================================================================  
  
  %hyperparams   
  a.ridge=10^(-13);  
  a.child = kernel;  
  a.indices = [];  
  a.use_b=1;  
     
  % model   
  a.alpha = [];  
  a.b0=0;  
  a.X=[];  
    
  p=algorithm('lms');  
  p.use_signed_output=0;  
  a= class(a,'lms',p);  
   
  if nargin==1,  
    eval_hyper;  
  end;  
  
    
  
