function a = mrs(hyper)

%=========================================================================   
% Multivariate Regression via Stiefel Constraints      
%=========================================================================
% author : gb  
% ostart=[];        possible start output features  for optimization
% qstart=[];        possible start input features  for optimization
% sstart=[];        possible start weighting
%  w0 initial guess: ostart * sstart *qstart'
%
% Final model : 
% o=[];
% s=[];
% q=[];
% w=[];
% 
% Hyper params :
% gamma = 0;        regularization parameter 
% k=5;              allowed components 
% conv_eps=1e-3;    optimization criteria
%
% Example:
%  [r,a]=train(mrs,toyreg);
%  loss(test(a,toy))
%=========================================================================
% Reference : Multivariate Regression via Stiefel Constraints
% Author    : Gkhan H. BakIr , Arthur Gretton , Bernhard Schlkopf 
% Link      : ----------------------------------------------------------------
%========================================================================= 

a.ostart=[];
a.qstart=[];
a.sstart=[];
a.o=[];
a.s=[];
a.q=[];
a.w=[];
a.gamma = 0;
a.k=5;
a.conv_eps=1e-3;




    
  p=algorithm('mrs');  
  p.use_signed_output=0;  
  a= class(a,'mrs',p);  
   
  if nargin==1,  
    eval_hyper;  
  end;  
  
    
  
